/* -*- c++ -*- */
#ifndef preference_h__
#define preference_h__

#include <akaxiso2/builtin/builtin.h>
#include <akaxiso2/builtin/schema_builtin.h>



namespace osp {

  /** complexType definitions */

  struct container_type {
    /** attributes */
    ::std::string type_;
  };

  struct escape {
    /** attributes */
    ::std::string to_escape_;
    ::std::string escaped_;
  };

  struct format {
    /** attributes */
    ::std::string prefix_;
    ::std::string suffix_;
  };

  struct _namespace {
    /** attributes */
    ::std::string prefix_;
    ::std::string uri_;
  };

  typedef std::list< ::osp::_namespace> namespace_array;

  struct substitution {
    /** attributes */
    ::std::string original_;
    ::std::string substituted_;
  };

  typedef std::list< ::osp::substitution> substitution_array;

  typedef std::list< ::osp::escape> escape_array;

  struct simplecontent_value_type {
    /** attributes */
    ::std::string name_;
  };

  struct type {
    /** members */
    ::std::string cpp_;
    aka::deep_ptr< ::std::string> typedef_;
    aka::deep_ptr< ::std::string> leaf_;
    ::std::string array_;
    aka::deep_ptr< ::std::string> array_typedef_;
    aka::deep_ptr< ::std::string> array_leaf_;
    /** attributes */
    ::std::string name_;
  };

  typedef std::list< ::osp::type> type_array;

  struct types {
    /** members */
    ::osp::type_array type_;
  };

  struct preference {
    /** members */
    ::osp::namespace_array namespace_;
    ::osp::substitution_array substitution_;
    ::osp::escape_array escape_;
    ::osp::container_type choice_container_;
    ::osp::container_type array_container_;
    ::osp::format member_format_;
    ::osp::format array_format_;
    ::osp::simplecontent_value_type simplecontent_value_;
    ::std::string nill_type_;
    ::osp::types builtins_;
    ::osp::types user_types_;
  };


}

#endif // #ifndef preference_h__
