#include "registry.h"
#include "preference.h"

namespace {
  
  struct system_builtin {
    const char *name_;
    const char *cpp_;
  };

  const system_builtin akaxiso_system_builtins[] = {
    // Must not be replaced.
//     {"xs:anyType", "aka:any"},
//     {"xs:anySimpleType", "std:string"},
    {"aka:any", "aka:any"},
    {"aka:any_array", "aka:any_array"},
    {"aka:wildcard", "aka:wildcard"},
    {0}
  };
}


using namespace osp;
using namespace osx;

bool registry_unit::type_exists(const aka::qname &type) const {
  return attributeGroups_.exists(type) || classes_.exists(type);
}

bool registry_unit::name_exists(const aka::qname &name) const {
  return elements_.exists(name)
    || gattributes_.exists(name)
    || simpleTypes_.exists(name);
}


bool registry_unit::is_toplevel(const aka::qname &name) const {
  return toplevels_.find(name) != toplevels_.end();
}


registry_unit &registry::operator[](const unit_props &unit) {
  for (registry_units::iterator it = registry_units_.begin();
       it != registry_units_.end(); ++it) {
    if ((*it)->target_ns_id_ == unit.target_ns_id_)
      return **it;
  }
  registry_unit *regunit = new registry_unit(unit.target_ns_id_);
  registry_units_.push_back(regunit);
  return *regunit;
}

bool registry::is_processed(const std::string &filename) const {
  for (unit_array::const_iterator it = units_.begin();
       it != units_.end(); ++it)
    if (it->filename_ == filename)
      return true;
  return false;
}


void registry::insert_simpleTypes() {
  type_array::iterator it;

  type_array &builtins = preference_->builtins_.type_;
  for (it = builtins.begin(); it != builtins.end(); ++it)
    predefinedSimpleTypes_.replace(aka::qname(it->name_), aka::qname(it->cpp_));

  type_array &user_types = preference_->user_types_.type_;
  for (it = user_types.begin(); it != user_types.end(); ++it)
    predefinedSimpleTypes_.replace(aka::qname(it->name_), aka::qname(it->cpp_));
}

bool registry::type_exists(const aka::qname &type) const {
  for (registry_units::const_iterator it = registry_units_.begin();
       it != registry_units_.end(); ++it) {
    if ((*it)->type_exists(type))
      return true;
  }
  return false;
}

bool registry::name_exists(const aka::qname &name) const {
  for (registry_units::const_iterator it = registry_units_.begin();
       it != registry_units_.end(); ++it) {
    if ((*it)->name_exists(name))
      return true;
  }
  return false;
}

const gattribute_def &registry::get_globalAttribute(const aka::qname &name) const {
  for (registry_units::const_iterator it = registry_units_.begin();
       it != registry_units_.end(); ++it) {
    const registry_unit *regunit = *it;
    if (regunit->gattributes_.exists(name))
      return regunit->gattributes_.get(name);
  }
  throw fatal_error(name.qualified() + " not found.", __FILE__, __LINE__);
  return *static_cast<gattribute_def*>(0);
}

bool registry::classdef_exists(const aka::qname &name) {
  for (registry_units::const_iterator it = registry_units_.begin();
       it != registry_units_.end(); ++it) {
    const registry_unit *regunit = *it;
    if (regunit->classes_.exists(name))
      return true;
  }
  return false;
}

class_def &registry::classdef_get(const aka::qname &name) {
  for (registry_units::const_iterator it = registry_units_.begin();
       it != registry_units_.end(); ++it) {
    const registry_unit *regunit = *it;
    if (regunit->classes_.exists(name))
      return *regunit->classes_.get(name);
  }
  throw fatal_error(name.qualified() + " not found.", __FILE__, __LINE__);
  return *static_cast<class_def*>(0);
}

bool registry::simpleType_exists(const aka::qname &name) {
  for (registry_units::const_iterator it = registry_units_.begin();
       it != registry_units_.end(); ++it) {
    const registry_unit *regunit = *it;
    if (regunit->simpleTypes_.exists(name))
      return true;
    if (is_predefined(name))
      return true;
  }
  return false;
}

bool registry::is_toplevel(const aka::qname &name) const {
  for (registry_units::const_iterator it = registry_units_.begin();
       it != registry_units_.end(); ++it) {
    const registry_unit *regunit = *it;
    if (regunit->is_toplevel(name))
      return true;
  }
  return false;
}

bool registry::attributeGroup_exists(const aka::qname &name) const {
  for (registry_units::const_iterator it = registry_units_.begin();
       it != registry_units_.end(); ++it) {
    const registry_unit *regunit = *it;
    if (regunit->attributeGroups_.exists(name))
      return true;
  }
  return false;
}

const attributeGroup_def &registry::attributeGroup_get(const aka::qname &name) const {
  for (registry_units::const_iterator it = registry_units_.begin();
       it != registry_units_.end(); ++it) {
    const registry_unit *regunit = *it;
    if (regunit->attributeGroups_.exists(name))
      return regunit->attributeGroups_.get(name);
  }
  throw fatal_error(name.qualified() + " not found.", __FILE__, __LINE__);
  return *static_cast<attributeGroup_def*>(0);
}



aka::qname registry::rename_type(const aka::qname &tyname) const {
  type_array::const_iterator tit; // iterator for type.
  const type_array &builtins = preference_->builtins_.type_;
  for (tit = builtins.begin(); tit != builtins.end(); ++tit) {
    if (aka::qname(tit->name_) == tyname)
      return aka::qname(tit->cpp_);
  }

  substitution_array::const_iterator sit; // iterator for substitution.
  const substitution_array &substitutions = preference_->substitution_;
  for (sit = substitutions.begin(); sit != substitutions.end(); ++sit) {
    if (tyname.local() == sit->original_)
      return aka::qname(tyname.get_namespace_id(), sit->substituted_);
  }
  return tyname;
}


bool registry::is_predefined(const aka::qname &tyname) const {
  const system_builtin *ty;
  for (ty = akaxiso_system_builtins; ty->name_ != 0; ++ty) {
    if (aka::qname(ty->name_) == tyname)
      return true;
  }

  type_array::const_iterator it;

  const type_array &builtins = preference_->builtins_.type_;
  for (it = builtins.begin(); it != builtins.end(); ++it)
    if (aka::qname(it->name_) == tyname)
      return true;
  const type_array &user_types = preference_->user_types_.type_;
  for (it = user_types.begin(); it != user_types.end(); ++it)
    if (aka::qname(it->name_) == tyname)
      return true;
  return false;
}


namespace {

  aka::qname resolve_one_types(const type_array &types, const aka::qname &tyname) {

    for (type_array::const_iterator it = types.begin(); it != types.end(); ++it) {
      if (aka::qname(it->name_) == tyname) {
	std::string *str = it->typedef_.get();
	if (str == 0)
	  return tyname;
	else
	  return aka::qname(*str);
      }
      else if (aka::qname(it->array_) == tyname) {
	std::string *str = it->array_typedef_.get();
	if (str == 0)
	  return tyname;
	else
	  return aka::qname(*str);
      }
    }
    return aka::qname();
  }
}

aka::qname registry::resolve_predefinedType(const aka::qname &tyname) const {
  const system_builtin *ty;
  for (ty = akaxiso_system_builtins; ty->name_ != 0; ++ty) {
    if (aka::qname(ty->name_) == tyname)
      return tyname;
  }

  aka::qname resolved = resolve_one_types(preference_->builtins_.type_, tyname);
  if (!resolved.empty())
    return resolved;

  resolved = resolve_one_types(preference_->user_types_.type_, tyname);
  if (!resolved.empty())
    return resolved;


  assert(!"Must not reach here.");
  return *static_cast<aka::qname*>(0);
}

bool registry::is_builtin(const aka::qname &type) const {
  type_array::const_iterator it;

  const type_array &builtins = preference_->builtins_.type_;
  for (it = builtins.begin(); it != builtins.end(); ++it)
    if (aka::qname(it->name_) == type)
      return true;
  return false;
}

std::string registry::get_predefined_leafname(const aka::qname &tyname) const {
  type_array::const_iterator it;

  const type_array &builtins = preference_->builtins_.type_;
  for (it = builtins.begin(); it != builtins.end(); ++it){
    if (aka::qname(it->name_) == tyname) {
      return std::string("xiso::leaf<") + to_cppname(it->cpp_) + ">";
    }
    else if (aka::qname(it->array_) == tyname) {
      if (!it->array_leaf_.get() != 0)
	return *it->array_leaf_;
      return to_cppname(it->array_) + "_leaf";
    }
  }

  const type_array &user_types = preference_->user_types_.type_;
  for (it = user_types.begin(); it != user_types.end(); ++it) {
    if (aka::qname(it->name_) == tyname) {
      if (it->leaf_.get() != 0)
	return to_cppname(*it->leaf_);
      return std::string("xiso::leaf<") + to_cppname(it->cpp_) + ">";
    }
    else if (aka::qname(it->array_) == tyname) {
      if (it->array_leaf_.get() != 0)
	return to_cppname(*it->array_leaf_);
      return to_cppname(it->array_) + "_leaf";
    }
  }

  assert(!"Must not reach here.");
  return std::string();
}



void registry::get_predefinedTypes(qname_set &qnames) const {
  const system_builtin *ty;
  for (ty = akaxiso_system_builtins; ty->name_ != 0; ++ty) {
    qnames.insert(aka::qname(ty->name_));
  }

  type_array::const_iterator it;

  const type_array &builtins = preference_->builtins_.type_;
  for (it = builtins.begin(); it != builtins.end(); ++it) {
    qnames.insert(aka::qname(it->name_));
    qnames.insert(aka::qname(it->array_));
  }

  const type_array &user_types = preference_->user_types_.type_;
  for (it = user_types.begin(); it != user_types.end(); ++it) {
    qnames.insert(aka::qname(it->name_));
    qnames.insert(aka::qname(it->array_));
  }
}


aka::qname registry::get_predefined_array(const aka::qname &name) const {

  type_array::const_iterator it;

  const type_array &builtins = preference_->builtins_.type_;
  for (it = builtins.begin(); it != builtins.end(); ++it)
    if (aka::qname(it->name_) == name)
      return aka::qname(it->array_);

  const type_array &user_types = preference_->user_types_.type_;
  for (it = user_types.begin(); it != user_types.end(); ++it)
    if (aka::qname(it->name_) == name)
      return aka::qname(it->array_);

  assert(!"Must not reach here.");
  return aka::qname();
}

bool registry::is_xs_any(const aka::qname &type) const {
  return (type == aka::qname("xs:anyType")) 
    || (type == aka::qname("xs:anySimpleType"));
}

bool registry::is_aka_any(const aka::qname &type) const {
  return (type == aka::qname("aka:any"))
    || (type == aka::qname("aka:any_array"));
}

std::string registry::escape(const std::string &to_escape) const {
  std::string escaped = to_escape;
  
  escape_array::const_iterator it;
  const escape_array &escapes = preference_->escape_;
  for (it = escapes.begin(); it != escapes.end(); ++it) {
    bool replaced;
    do {
      replaced = false;
      std::string::size_type pos = escaped.find(it->to_escape_);
      if (pos != std::string::npos) {
	std::string::size_type len = std::string(it->to_escape_).size();
	escaped = escaped.substr(0, pos) + it->escaped_ + 
	  escaped.substr(pos + len);
	replaced = true;
      }
    } while (replaced);
  } 
  return escaped;
}

void registry::register_ns() {
  namespace_array &namespaces = preference_->namespace_;
  for (namespace_array::iterator it = namespaces.begin(); it != namespaces.end(); ++it)
    aka::xmlns(it->prefix_, it->uri_);
}


std::string registry::to_cppname(const std::string &name) {
  aka::qname qn(name);
  if (qn.is_qualified())
    return qn.prefix() + "::" + qn.local();
  return qn.local();
}

void registry::save_preference(std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.default_ns_prefix("osp");
  ser.serialize(*preference_, "osp:preference", ostm);
}

void registry::load_preference(const std::string &filename) {
  if (preference_ != 0)
    delete preference_;
  aka::document doc = aka::deserialize_file(filename);
  preference_ = aka::adopt_root<osp::preference>(doc);
}

const std::string &registry::choice_container_type() const {
  return preference_->choice_container_.type_;
}

const std::string &registry::array_container_type() const {
  return preference_->array_container_.type_;
}

const std::string &registry::simplecontent_value_name() const {
  return preference_->simplecontent_value_.name_;
}

const std::string &registry::get_member_prefix() const {
  return preference_->member_format_.prefix_;
}

const std::string &registry::get_member_suffix() const {
  return preference_->member_format_.suffix_;
}

const std::string &registry::get_array_prefix() const {
  return preference_->array_format_.prefix_;
}

const std::string &registry::get_array_suffix() const {
  return preference_->array_format_.suffix_;
}

const std::string &registry::get_nill_type() const {
  return preference_->nill_type_;
}
