//CUPPA:include=+
#include <akaxiso2/akaxiso2.h>
#include <akaxiso2/content_model.h>
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

//CUPPA:namespace=+
//CUPPA:namespace=-

namespace {

  struct seq {
    std::string value_;
  };

  struct ptrmem {
    aka::deep_ptr<seq> seq_;
    std::string strval_;
  };

  struct seq_leaf : aka::sequence<seq, seq_leaf> {
    void model() {
      member("seqval", &seq::value_);
    }
  };

  struct ptrmem_leaf : aka::sequence<ptrmem, ptrmem_leaf> {
    void model() {
      ptrmember("&test", &ptrmem::seq_, seq_leaf());
      member("value", &ptrmem::strval_);
    }
  };
}

class ptrmemberTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(ptrmemberTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test_group);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...

public:

  virtual void setUp() {
    aka::initialize();
    aka::doctype("ptrmem", ptrmem_leaf());
  }
  virtual void tearDown() {
    aka::uninitialize();
  }

//CUPPA:decl=+
  void test_group() {
    const char* docstr =
      "<?xml version=\"1.0\"?>\n"
      "<ptrmem>\n"
      "<value>test</value>\n"
      "</ptrmem>\n";

    aka::document doc = aka::deserialize(docstr);

    ptrmem *root = aka::root_cast<ptrmem>(doc);
    CPPUNIT_ASSERT_MESSAGE("Empty ptrmember is created.", root->seq_.get() == 0);
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(ptrmemberTest);
