#include "expat_deserializer.h"

#ifdef AKAXISO2_USE_EXPAT

#include "expat_handler.h"
#include "../../framework/document.h"
#include <iostream>
#include <fstream>

using namespace aka2;

document expat_deserializer::deserialize(std::istream &istm) {
  return deserialize_istream(istm, "(std::istream)");
}

document expat_deserializer::deserialize_stdin(){
  return deserialize_istream(std::cin, "(stdin)");
}

document expat_deserializer::deserialize(const char *buff){
  return deserialize_chars(buff, strlen(buff), "(membuf)");
}

document expat_deserializer::deserialize(const std::string& document){
  return deserialize_chars(document.c_str(), document.size(), "(std::string)");
}

document expat_deserializer::deserialize_file(const std::string &filename) {
  std::ifstream istm(filename.c_str());
  if (!istm.is_open()) {
    throw error(std::string("Failed to open file, " + filename + "."), __FILE__, __LINE__);
  }
  return deserialize_istream(istm, filename);
}

document expat_deserializer::deserialize_chars(const char *buffer, int len,
					       const std::string &source_name) {
  expat_parser parser;
  expat_handler handler(ecomp_);
  parser.set_document_handler(handler);
  parser.parse_buffer(buffer, len, source_name);
  return handler.get_document();
}

document expat_deserializer::deserialize_istream(std::istream &istm, 
						 const std::string &source_name) {
  expat_parser parser;
  expat_handler handler(ecomp_);
  parser.set_document_handler(handler);
  parser.parse_istream(istm, source_name);
  return handler.get_document();
}


#endif
