/* -*- c++ -*- */
#ifndef AKAXISO2_XML_SERIALIZER_XML_SERIALIZER_BASE_H__
#define AKAXISO2_XML_SERIALIZER_XML_SERIALIZER_BASE_H__

/**
 * @file akaxiso2/XML/serializer/xml_serializer_base.h 
 * @brief Base class of XML serializer 
 */

#include <akaxiso2/XML/serializer/serializer.h>
#include <akaxiso2/framework/operators.h>
#include <akaxiso2/framework/entity_complements.h>

namespace aka2 {

  struct wildcard;
  typedef std::vector<wildcard> wc_array;

  /** 
   * @brief Base class of XML serializer.
   *
   * This class implements XML serialization logic except for encoding-translation.
   * Derived classes are responsible to initialize serializer::formatter_ member.
   */
  class xml_serializer_base : public serializer {
  public:
    explicit xml_serializer_base(const std::string &encoding)
      : serializer(2), encoding_(encoding), ns11_enabled_(true) {};
    virtual ~xml_serializer_base();

    /** 
     * Property to use XML-namespace 1.1.
     * @param value true to use XML-namespace 1.1(default). false to dsiable.
     */
    void enable_ns11(bool value) { ns11_enabled_ = value; }

  private:
    std::string encoding_;
    bool ns11_enabled_;

    virtual void serialize_internal(const void *e, const element_props &props, 
				    const qname &name);

    void write_element(const void *e, const element_props &props, const element_op &op);
    void write_element_entity(const void *e, const element_props &props, const element_op &op);

    void write_sequence(const qname &tagname,
                        const void *e, const sequence_op &sop);
    void write_sequence_entity(const void *e, const sequence_op &sop);

    void write_choice(const qname &tagname, 
                      const void *e, const choice_op &sop);
    void write_choice_entity(const void *e, const choice_op &sop);

    void write_all(const qname &tagname,
                   const void *e, const all_op &sop);
    void write_all_entity(const void *e, const all_op &sop);

    void write_simplecontent(const qname &tagname, 
                             const void *e, const simplecontent_op &sop);
    void write_array(const void *e, const element_props &props, const array_op &aop);
    void write_group_array(const void *e, const element_props &props, const array_op &aop);
    void write_ptrmember(const void *e, const element_props &props);
    void write_ptrmember_entity(const void *e, const element_props &props);

    void write_simpletype(const qname &tagname,
                          const void *e, const simpletype_op &sop);

    void write_fixed_simpletype(const element_props &props);


    void write_nill_element(const qname &tagname,
                            const void *e, const element_op &op);
    void write_beginning_tag(const qname& tagname,
                             const void *e, const element_op &op);
    void write_ending_tag(const qname &tagname);

    void write_attributes(const void *e, const element_op &op);
    void write_namespace_attributes();
    void write_ns(id_type nsid);
    void write_ns11_declaration(const qname &tagname, const element_op &op, const void *e);

    void write_any(const element_props &props, const any &an);
    void write_any_array(const element_props &props, const any_array &ar);
    void write_wildcard(const element_props &props, const wildcard &wc);
    void write_wildcard_array(const element_props &props, const wc_array &ar);
    void write_anyType(const qname &tagname, const wildcard &an);
    void write_anyType_array(const qname &tagname, const wc_array &ar);
    void write_ns_decl_if_new(id_type nsid);
  };

} // namespace aka2

#endif
