/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_DOCUMENT_factory_H__
#define AKAXISO2_FRAMEWORK_DOCUMENT_factory_H__

/**
 * @file akaxiso2/framework/document_factory.h 
 * @brief document factory
 */


#include <akaxiso2/framework/document.h>
#include <map>

namespace aka2 {

  class document_factory {
  public:
    element_props &register_document_type(const qname &docname,
					  const element_op &op);
    void register_document_type(const qname &docname,
				const element_op &op,
				default_op *defop,
				const std::string &defval);
    bool is_document_type_registered(const qname &docname) const;
    document create_named_document(const qname &docname);
    const element_props &get_props(const qname &docname) const;
    void clear() { doctype_map_.clear(); }

  private:
    typedef std::map<qname, element_props, qname_less> doctype_map;
    doctype_map doctype_map_;
  };

} // namespace aka2

#endif
