/* -*- c++ -*- */
#ifndef AKAXISO2_LIBSELECTION_H__
#define AKAXISO2_LIBSELECTION_H__

/** 
 * @file akaxiso2/libselection.h
 * @brief definitions of default xml_serializer/xml_deserializer.
 */

#ifdef AKAXISO2_USE_XERCESC
#include <memory.h> /* {BCB6} */
#include <akaxiso2/XML/xerces/xerces_serializer.h>
#include <akaxiso2/XML/xerces/xerces_deserializer.h>


namespace aka2 {
  /**
   * @class xml_serializer
   * @brief The default XML serializer class of akaxiso library, 
   *
   * xml_serializer is a typedef name of an aka2::xml_serializer_base derived class.\n
   *
   * The xml_serializer is typedef'ed according to the following rules.\n
   * Rule1. If Xerces-C++ is enabled, xml_serializer is 
   * the typedef name of aka2::xerces_serializer.\n
   * Rule2. If babel is enabled and Xerces-C++ is disabled, 
   * xml_serializer is the typedef name of aka2::babel_serializer.\n
   * Rule3. If both babel and Xerces-C++ are disabled, 
   * xml_serizlier is the typedef name of aka2::default_serializer.\n
   */
  
  /**
   * @class xml_deserializer
   * @brief The default XML deserializer class of akaxiso library.
   *
   * The xml_deserializer is typedef'ed according to the following rules.\n
   * Rule1. If Xerces-C++ is enabled, xml_deserializer is the typedef name 
   * of aka2::xerces_deserializer.\n
   * Rule2. If Xerces-C++ is diabled, xml_deserializer is 
   * the typedef name of aka2::expat_deserializer.\n
   */


  typedef xerces_serializer xml_serializer;
  typedef xerces_deserializer xml_deserializer;
}

# define SERIALIZER_TYPES_DECLARED 1
# define DESERIALIZER_TYPES_DECLARED 1

#endif


#ifdef AKAXISO2_USE_BABEL
# include <akaxiso2/XML/babel/babel_serializer.h>
# if !defined(SERIALIZER_TYPES_DECLARED)
# define SERIALIZER_TYPES_DECLARED
namespace aka2 {
  typedef babel_serializer xml_serializer;
}

# endif
#endif

#if !defined(SERIALIZER_TYPES_DECLARED)
# include <akaxiso2/XML/serializer/default_serializer.h>
namespace aka2 {
  typedef default_serializer xml_serializer;
}
#endif


#ifdef AKAXISO2_USE_EXPAT
# include <akaxiso2/XML/expat/expat_deserializer.h>
# if !defined(DESERIALIZER_TYPES_DECLARED)
#  define DESERIALIZED_TYPES_DECLARED 1
namespace aka2 {
  typedef expat_deserializer xml_deserializer;
}
# endif
#endif


#endif

