#include "XMLSchema_xiso.h"
#include <akaxiso2/util/string_funcs.h>

#include "schema_st.h"

namespace xs {

  void allNNI_leaf::write_text(const void *e, std::ostream &ostm,
			       aka::entity_complements &ecomp) {
    const long &v = *static_cast<const long*>(e);
    if (v == aka::unbounded)
      ostm << "unbounded";
    else
      ostm << v;
  }
  
  void allNNI_leaf::read_text(void *e, const std::string &entity, 
			      aka::entity_complements &ecomp) {
    long &v = *static_cast<long*>(e);
    std::string val = aka::trim(entity);
    if (val == "unbounded") {
      v = aka::unbounded;
      return;
    }

    aka::isstream istm(entity);
    istm >> v;
    if (istm.fail())
      throw aka::error(std::string("Failed to parse allNNI(maxOccurs) value.(")
		       + istm.rdbuf()->str() + ")",
		       __FILE__, __LINE__);
  }

}
