/* -*- c++ -*- */
#ifndef AKAXISO2_XML_DESERIALIZER_ALL_HANDLER_H__
#define AKAXISO2_XML_DESERIALIZER_ALL_HANDLER_H__

/** @file akaxiso2/parser/all_handler.h */

#include <akaxiso2/XML/deserializer/handler.h>
#include <akaxiso2/framework/member_cache.h>

namespace aka2 {

  class all_handler : public handler {
  public:
    all_handler(bool emptiable, void *all, const all_op &aop,
		int depth,
		const element_props &props,
		parser_context &context);
    
    virtual ~all_handler(){}
    virtual validation_result query_element(const qname &tagname, const attribute_values &attrs);
    virtual validation_result end_element(const qname &tagname);
    virtual validation_result query_next(const qname &tagname, const attribute_values &attrs);
    virtual bool parse_entity(const pstring &entity);

    virtual node get_node();
    virtual void receive_child(const node &child);
    virtual bool can_skip();
    virtual void abort();
    
  private:
    validation_result parse_element(const member_type &mtype, const attribute_values &attrs);
    void *all_;
    const all_op &aop_;

    typedef std::map<qname, const member_type*, qname_less> member_map;
    member_map mmap_;
    member_map::const_iterator current_;
    member_cache cache_;
  };

} // namespace aka2

#endif
