/* -*- c++ -*- */
#ifndef AKAXISO2_XML_DESERIALIZER_ARRAY_HANDLER_H__
#define AKAXISO2_XML_DESERIALIZER_ARRAY_HANDLER_H__

/** @file akaxiso2/XML/deserializer/array_handler.h */

#include <akaxiso2/XML/deserializer/handler.h>

namespace aka2 {

  class array_handler : public handler {
  public:
    array_handler(bool emptiable, void *ma, 
		  int depth,
		  const qname &tagname, const element_props &props,
		  parser_context &context);
    virtual ~array_handler();
    virtual validation_result query_element(const qname &tagname, const attribute_values &attrs);
    virtual validation_result end_element(const qname &tagname);
    virtual validation_result query_next(const qname &tagname, const attribute_values &attrs);
    virtual bool parse_entity(const pstring &entity);

    virtual node get_node();
    virtual void receive_child(const node &child);

    virtual bool can_skip();
    virtual void abort(); 

  private:
    validation_result parse_element(const qname &tagname, const attribute_values &attrs,
				    void **e);
    validation_result find_particle(const qname &tagname, const attribute_values &attrs, 
				    void **e);

    void *array_;
    void *e_;
    const array_op &aop_;
    int count_;
    qname tagname_;
    bool is_element_;
  };

} // namespace aka2

#endif
