/* -*- c++ -*- */
#ifndef AKAXISO2_XML_SERIALIZER_SERIALIZER_H__
#define AKAXISO2_XML_SERIALIZER_SERIALIZER_H__

/**
 * @file akaxiso2/XML/serializer/serializer.h
 * @brief serializer class (base of any serializer)
 */

#include <akaxiso2/framework/membertype.h>
#include <akaxiso2/framework/any.h>
#include <akaxiso2/framework/document.h>
#include <akaxiso2/XML/serializer/formatter.h>
#include <set>
#include <stack>

namespace aka2 {

  class entity_complements;
  
  /** @brief Base class of any serializer. */
  class serializer  {
  public:
    serializer(int tab, const std::string &encoding, transcoder_factory create);
    virtual ~serializer();

    /** 
     * @brief Declare namespace prefix for namespace declared at the root node.
     * @param prefix namespace prefix declared by aka::xmlns().
     */
    void using_prefix(const std::string &prefix);

    /** 
     * @brief Declare namespace URI for namespace declared at the root node.
     * @param uri namespace URI declared by aka::xmlns().
     */
    void using_uri(const std::string &uri);

    /**
     * @brief Specify default namespace prefix.
     * @param prefix namespace prefix
     */
    void default_ns_prefix(const std::string &prefix);

    /**
     * @brief Specify default namespace URI.
     * @param uri namespace URI
     */
    void default_ns_uri(const std::string &uri);

  protected:
    void prepare(std::ostream &ostm);
    void finish();
  private:
    int indent_;
    pstring indent_str_;

    int any_depth_;

  protected:
    void inc_indent_level() { ++indent_; }
    void dec_indent_level() { --indent_; }
    void new_line();

    void inc_ns_depth();
    void dec_ns_depth();
    bool is_new_ns(id_type id) const;
    void use_temp_nsdecl(id_type id);

    /** Text formatting object for encoding-translation. */
    formatter formatter_;
    bool is_root_;

    typedef std::vector<id_type> ids;
    ids nsids_;
   
    typedef std::set<id_type> ns_set;
    typedef std::stack<ns_set> ns_stack;
    ns_stack ns_stack_;
    entity_complements *ecomp_;
    std::string encoding_;
  };

} // namespace aka2

#endif
