/* -*- c++ -*- */
#ifndef AKAXISO2_TRANSCODERS_STATEFUL_TRANSCODER_H__
#define AKAXISO2_TRANSCODERS_STATEFUL_TRANSCODER_H__

/**
 * @file akaxiso2/transcoders/stateful_transcoder.h
 * @brief stateful_transcoder interface and base classes. 
 */

#include <string>
#include <akaxiso2/transcoders/transcoder.h>

namespace aka2 {

  class stateful_transcoder {    
  private:
    transcoder *transcoder_;
    bool current_result_;

    const struct char_mark *bom_;
    bool bom_to_add_;
    bool bom_to_check_;

    /** 
     * @brief char_mark management.
     * Add char_mark to outbuf_, if char_mark is required and transcoder does not output it. 
     * (for stateful_transcoder).
     */
    stateful_transcoder(transcoder *tc, 
			const struct char_mark *bom, bool bom_to_add);
  public:
    ~stateful_transcoder();
    void clear_transcoded_buffer();
    void reset();
    bool transcode(const char *to_convert, size_t length);
    string_buffer &get_buffer() { return transcoder_->outbuf_; }

    static stateful_transcoder *create(const std::string &tocode, 
				       const std::string &fromcode,
				       bool bom_to_add,
				       transcoder_factory tf);
  };

}

#endif
