#include "platform.h"
#include "../exception.h"

#include <iostream>


#if defined(_MSC_VER) && _MSC_VER < 1300

std::istream &operator >>(std::istream &istm, _int64 &value) {
  char buf[256];
  istm.getline(buf, sizeof(buf));
  if (sscanf(buf, "%I64d", &value) != 1)
    throw aka2::error("Failed to parse LONGLONG", __FILE__, __LINE__);
  return istm;
}

std::istream &operator >>(std::istream &istm, unsigned _int64 &value) {
  char buf[256];
  istm.getline(buf, sizeof(buf));
  if (sscanf(buf, "%I64u", &value) != 1)
    throw aka2::error("Failed to parse LONGLONG", __FILE__, __LINE__);
  return istm;
}

std::ostream &operator <<(std::ostream &ostm, const unsigned _int64 &value) {
  ostm << value;
  return ostm;
}

std::ostream &operator <<(std::ostream &ostm, const _int64 &value) {
  ostm << value;
  return ostm;
}

#endif /* defined(_MSC_VER) && _MSC_VER < 1300 */

unsigned int aka2::readsome(std::istream &istm, char * toFill, const unsigned int maxToRead) {
#ifdef AKAXISO2_ISTREAM_READSOME_SUPPORTED
  unsigned int read_size = istm.readsome(reinterpret_cast<char*>(toFill), maxToRead);
  if (read_size != 0)
    return read_size;
#endif
  unsigned int index = 0;
  for (;index < maxToRead; ++index) {
    istm.get(*reinterpret_cast<char*>(toFill));
    if (istm.fail())
      break;
    ++toFill;
  }
  return index;
}

#define BUFF_SIZE 1024

unsigned int aka2::readsome(std::istream &istm, std::string &toFill, 
			    const unsigned int maxToRead) {
  char buffer[BUFF_SIZE];
  unsigned int current_max = maxToRead < BUFF_SIZE ? maxToRead : BUFF_SIZE;

  for (unsigned int index = 0; (index < maxToRead); ) {
    unsigned int read_size = readsome(istm, buffer, current_max);
    toFill.append(buffer, read_size);
    index += read_size;
    if (read_size < BUFF_SIZE)
      break;
    if (istm.fail()) {
      break; //throw error("Failed to read std::istream", __FILE__, __LINE__);
    }
  }
  return toFill.size();
}
