#include <akaxiso2/akaxiso2.h>
#include <iostream>


/** 
 *  serializer.h generated by osixaka2 includes decarations 
 *  for element classes and serialization functions.
 */
#include "serializer.h"

void process_anys(const aka::any_array &anys) {
  for (aka::any_array::const_iterator it = anys.begin();
       it != anys.end(); ++it) {
    if (!it->document_.empty()) {
      std::cout << aka::document_name(it->document_) << " parsed." << std::endl;

      if (aka::document_of(it->document_, "xs:schema"))
	serialize(*aka::root_cast<xs::schema>(it->document_), std::cout);
    }

  }
}

template<class T>
void process_item(const aka::item &item) {
  const T &t = aka::item_cast<T>(item);
  process_anys(t.any_);
}

int main(int argc, char* argv[]){
  
  // initialize akaxiso library.
  aka::initialize();
  // instantiate xiso::leaf classes to allow xs:schema to be deserialized.
  // instantiate_xiso();
  instantiate_xiso();

  // parsing from stdin.
  aka::document doc;
  try {
    doc = aka::deserialize(std::cin);
  }
  catch (const aka::error &e) {
    std::cerr << e.what() << std::endl;
    std::cerr << "Parse error detected.  Abort immediately." << std::endl;
    exit(1);
  }
  catch ( ... ) {
    std::cerr << "Unhandled parse error detected.  Abort immediatedly." << std::endl;
    exit(1);
  }
  
  const wsdl::tDefinitions *defs = aka::root_cast<wsdl::tDefinitions>(doc);
  const wsdl::anyTopLevelOptionalElement &optelm = defs->anyTopLevelOptionalElement_;
  for (wsdl::anyTopLevelOptionalElement::const_iterator it = optelm.begin();
       it != optelm.end(); ++it) {
    std::cout << it->get_name().qualified() << std::endl;
//     if (aka::item_of(*it, "wsdl:import")) {
//       process_item<wsdl::tImport>(*it);
//     }
    if (aka::item_of(*it, "wsdl:types")) {
      process_item<wsdl::tTypes>(*it);
    }
    else if (aka::item_of(*it, "wsdl:message")) {
      process_item<wsdl::tMessage>(*it);
    }
    else if (aka::item_of(*it, "wsdl:portType")) {
      const wsdl::tPortType &portType = aka::item_cast<wsdl::tPortType>(*it);
      for (wsdl::tOperation_array::const_iterator it = portType.operation_.begin();
	   it != portType.operation_.end(); ++it)
	process_anys(it->any_);
    }
    else if (aka::item_of(*it, "wsdl:binding")) {
      process_item<wsdl::tBinding>(*it);
      const wsdl::tBinding &binding = aka::item_cast<wsdl::tBinding>(*it);
      for (wsdl::tBindingOperation_array::const_iterator it = binding.operation_.begin();
	   it != binding.operation_.end(); ++it) {
	process_anys(it->any_);
	if (it->input_.get() != 0)
	  process_anys(it->input_.get()->any_);
	if (it->output_.get() != 0)
	  process_anys(it->output_.get()->any_);
      }
    }
    else if (aka::item_of(*it, "wsdl:service")) {
      process_item<wsdl::tService>(*it);
    }
  }

  // serialization of schema instance to std::cout.
  aka2::serialize(doc, std::cout);

  // Uninitialize akaxiso to release global res2ources.
  aka::uninitialize();

  return 0;
}
