#include "membertype.h"


using namespace aka2;

bool attribute_type::should_write(const void *elm) const {
  if ((use_ == optional) && is_default(elm))
    return false;
  return true;
}

memberpair member_type::get_member(void *e) const {
  void *mem = mgetter_->get_member(e);
  const element_op *eo = mgetter_->get_op();
  return memberpair(mem, *eo);
}

const_memberpair member_type::get_member(const void *element) const {
  const void *mem = mgetter_->get_member(element);
  const element_op *eo = mgetter_->get_op();
  return const_memberpair(mem, *eo);
}

bool member_type::equals(const void *lhs, const void *rhs) const {
  const_memberpair lhspair = get_member(lhs);
  const_memberpair rhspair = get_member(rhs);

  if (&lhspair.op_ != &rhspair.op_)
    throw internal_error();

  return lhspair.op_.equals(lhspair.e_, rhspair.e_);
}


void member_type::copy(void *dest, const void *src) const {
  memberpair destpair = get_member(dest);
  const_memberpair srcpair = get_member(src);

  if (&destpair.op_ != &srcpair.op_)
    throw internal_error();

  srcpair.op_.copy(destpair.e_, srcpair.e_);
}

