#include "simpletype_handler.h"
#include <cassert>
#include <sstream>

using namespace aka2;


simpletype_handler::simpletype_handler(const qname &tagname, 
				       void *e, 
				       int depth,
				       const simpletype_op &sop, 
				       parser_context &context) 
  : handler(context, depth, tagname), elm_(e), sop_(sop) {}


parse_result simpletype_handler::query_element(const qname &tagname, 
					       const attribute_values &attrs, 
					       const global_attributes &gattrs) {
  context_.raise_error("Unexpected call.", __FILE__, __LINE__);
  assert(!"Must not be called.");
  return ok;
}


parse_result simpletype_handler::end_element(const qname &tagname){
  return ok;
}

bool simpletype_handler::parse_entity(const std::string &entity, const global_attributes &gattrs) {
  std::istringstream istm(entity);
  try {
    sop_.read_text(elm_, istm, gattrs);
    return true;
  }
  catch ( ... /* !!!!!!!!!!!!!!!!!!!!!! */ ) {
    return false;
  }
}


// Mainly used for choices.
memberpair simpletype_handler::get_element(){
  return memberpair(elm_, sop_);
}

void simpletype_handler::receive_child(const memberpair &mpair){
  assert(!"Must not be called.");
  assert(&sop_ == &mpair.op_);
}

bool simpletype_handler::can_skip() {
  return false;
}

void simpletype_handler::abort() {
}
