// -*- c++ -*-
#ifndef AKAXISO_SOX_SERIALIZER_H__
#define AKAXISO_SOX_SERIALIZER_H__

#include <akaxiso/classes/types.h>
#include <akaxiso/classes/traits.h>
#include <akaxiso/serializer.h>

namespace aka2 {
  
  class soxserializer : public serializer {
  public:
    soxserializer(const std::string &encoding = "UTF-8") : serializer(4), encoding_(encoding){};
    virtual void serialize(const document *doc, std::ostream &ostm);
  private:
    void write_element(const memberpair &mp, const std::string &tagname, std::ostream &ostm);
    void write_element_tag(const std::string &tagname, std::ostream &ostm);
    void write_entity(const void* e, const value_op &vo, std::ostream &ostm);

    void write_namespace_attributes(std::ostream &ostm);

    std::string encoding_;
    int indent_;
  };

}


#endif




