/* -*- c++ -*- */
#ifndef TYPE_TRANSLATOR_H__
#define TYPE_TRANSLATOR_H__

#include <map>
#include <akaxiso/akaxiso.h>

namespace osixaka {

  class type_translator {
  public:
    typedef std::map<aka::qname, std::string, aka::qname_less> transmap_type;
    const std::string& translate(const aka::qname &xmltype) const;
    bool exists(const aka::qname &xmltype) const;
    void insert(const aka::qname &xmltype, const std::string &cppname = std::string());
  protected:
    transmap_type transmap_;
  };
  
}

#endif
