/* -*- c++ -*- */
#ifndef AKAXISO_PTRMEMBER_H__
#define AKAXISO_PTRMEMBER_H__

#include <akaxiso/classes/traits.h>

namespace aka2 {
  

  template<class L, class VL>
  struct ptrmember_op_dispatcher : public ptrmember_op {
  public:
    virtual schematype_id get_schematype() const { return ptrmember_id; }
    virtual const typeinfo& get_typeinfo() const { return VL::typeinfo_; }
    virtual const attribute_types *get_attribute_types() const { return 0; } 
    virtual void* create() const { assert(!"Must not be called."); return 0; }
    virtual void  destroy(void *elm) const { assert(!"Must not be called."); }
    virtual bool equals(const void *lhs, const void *rhs) const {
      return L::equals(lhs, rhs);
    }
    virtual void copy(void *dest, const void *src) const {
      L::copy(dest, src);
    }
    
    virtual void set_null(void *elm) const { L::set_null(elm); }
    virtual void *create_member(void *elm) const { return L::create(elm); }
    virtual void destroy_member(void *elm) const { L::destroy(elm); }
    virtual bool  is_null(const void *elm) const { return L::is_null(elm); }

    virtual void *dereference(void *elm) const {
      return L::dereference(elm);
    }
    virtual const void *dereference(const void *elm) const {
      return L::dereference(elm);
    }
    virtual const element_op& get_value_op() const {
      return VL::dispatcher_;
    };

  };




  template<class V, class VL = xiso::leaf<V> >
  class ptrmember {
  public:
    typedef ptrmember<V, VL> self_type;

    static void initialize() {  
      system_type_registory().add(L());
    }
    static void uninitialize() {}

    static bool is_null(const void *elm) { return *static_cast<V* const*>(elm) == 0; }

    static void *create(void *elm) {
      V** v = static_cast<V**>(elm);
      if (*v == 0)
	*v = new V;
      return *v;
    }
    static void destroy(void *elm) {
      V** v = static_cast<V**>(elm);
      if (*v != 0)
	delete *v;
      *v = 0;
    }

    static bool equals(const void *lhs, const void *rhs) {
      return ptrmember_equals(lhs, rhs, dispatcher_);
    }
    static void copy(void *dest, const void *src) {
      ptrmember_copy(dest, src, dispatcher_);
    }

    static V* dereference(void *elm) {
      return *static_cast<V**>(elm);
    }
    static const V* dereference(const void *elm) {
      return *static_cast<const V* const *>(elm);
    }
    static void set_null(void *elm) {
      *static_cast<void**>(elm) = 0;
    }

    static ptrmember_op_dispatcher<self_type, VL> dispatcher_;
    static ptrmember_op_dispatcher<self_type, VL> *get_attribute_dispatcher() { return 0; }
    static default_op* create_default_op() { return 0; }
  };

  template<class V, class VL>
  ptrmember_op_dispatcher<ptrmember<V, VL>, VL> ptrmember<V, VL>::dispatcher_;

}

#endif
