/* -*- c++ -*- */
#ifndef AKAXISO_MACRODEFS_H__
#define AKAXISO_MACRODEFS_H__


#define ITEM(tagname) \
  tag_##tagname::set_tagname(namespace_.uri(), #tagname); \
  finalclass::choice_info_.register_iteminfo(&finalclass::tag_##tagname::get_iteminfo());

#define ITEMTYPE(tagname, classname) \
  void push_back(classname *ct) {  choice::push_back(ct, tag_##tagname::get_iteminfo().get_qname());   } \
  struct tag_##tagname : public akaxiso::iteminfo_impl<classname>  {   }; \
  static const akaxiso::iteminfo& get_classinfo(const classname* n = NULL){ return tag_##tagname::get_iteminfo();  }



#define OCCURENCE(minOcc, maxOcc)
#define FIXED(fixed_value)

// Namespace related macros.

#define DECLARE_NAMESPACE(prefix_name, uri_name) \
  struct namespace_##prefix_name { static const char *uri(){ return uri_name;} static const char *prefix(){ return #prefix_name; } };


#define MEMBER(name, member) \
  op = akaxiso::create_member_operator(myclass, &finalclass::member); \
  meminfo = akaxiso::member_info(op); \
  meminfo.set_name(finalclass::namespace_.uri(), name); \
  sequence_info_.register_memberinfo(meminfo);


#define ATTRIBUTE(name, member) \
  op = akaxiso::create_attribute_operator(myclass, &finalclass::member); \
  meminfo = akaxiso::member_info(op); \
  meminfo.set_name(finalclass::namespace_.uri(), name); \
  attribute_info_.register_memberinfo(meminfo);


#define DEFAULT(defval) \
  {  akaxiso::simpletype_member_type *simtype = static_cast<akaxiso::simpletype_member_type*>(op); \
     simtype->set_default_value(defval); }


#define NAMESPACE(prefix_name) \
  finalclass::namespace_ = akaxiso::namespace_uri(namespace_##prefix_name::uri()); \
  akaxiso::namespaces().register_namespace_uri(namespace_##prefix_name::uri()); \
  akaxiso::static_global_attributes().associate_namespace_prefix(#prefix_name, namespace_##prefix_name::uri());  \


#endif
