#include "attributeinfo.h"
#include "membertypes.h"

using namespace akaxiso;

void attribute_info::register_memberinfo(member_info &desc) {
  member_infos_.push_back(desc);
}


void attribute_info::clear() {
  for (member_info_array::iterator it = member_infos_.begin();
       it != member_infos_.end(); ++it)
    it->clear();
  member_infos_.clear();
}


bool attribute_info::is_equal(const element & element1, const element &element2) const{
  for (member_info_array::const_iterator cit = member_infos_.begin();
       cit != member_infos_.end(); ++cit) {
    bool b = cit->get_member_operator().is_equal(element1, element2);
    if (!b)
      return false;
  }
  return true;
}


void attribute_info::copy(element & dst, const element &src) const {
   for (member_info_array::const_iterator cit = member_infos_.begin();
       cit != member_infos_.end(); ++cit) 
    cit->get_member_operator().copy(dst, src);
}


void attribute_info::initialize_instance(element &seq) const {
   for (member_info_array::const_iterator cit = member_infos_.begin();
       cit != member_infos_.end(); ++cit) 
    cit->get_member_operator().initialize_instance(seq);
}
