/* -*- c++ -*- */
#ifndef AKAXISO_ATTRIBUTE_H__
#define AKAXISO_ATTRIBUTE_H__

#include <akaxiso/classes/sequence.h>

namespace akaxiso {

  class attribute_info {
    typedef std::vector<member_info> member_info_array;
  public:
    typedef member_info_array::iterator iterator;
    typedef member_info_array::const_iterator const_iterator;
    void register_memberinfo(member_info &info);

    const_iterator begin() const {
      return member_infos_.begin();
    }
    const_iterator end() const {
      return member_infos_.end();
    }

    void initialize_instance(element &seq) const;
    bool is_equal(const element & sequence1, const element &sequence2) const;
    void copy(element & dst, const element &src) const;

    void clear();

  private:
    member_info_array member_infos_;
  };

}

#endif
