/* -*- c++ -*- */
#ifndef AKAXISO_BASE_IMPL_H__
#define AKAXISO_BASE_IMPL_H__

#include <akaxiso/classes/attributeinfo.h>
#include <akaxiso/classes/name.h>
#include <akaxiso/classes/namespaces.h>

namespace akaxiso {

  template<class T>
  class  base_impl {
  protected:

    struct define_attribute {
      template<class P, class V>  
      define_attribute(const char *tagname, V P::* member) {
	      op_ = akaxiso::create_attribute_operator(reinterpret_cast<T*>(0), member);
	      member_info meminfo = akaxiso::member_info(op_); 
	      meminfo.set_name(tagname); 
	      T::static_attribute_info().register_memberinfo(meminfo);
      }
      void set_default_value(const char *defval) {
	akaxiso::simpletype_member_type *simtype = static_cast<akaxiso::simpletype_member_type*>(op_); 
	simtype->set_default_value(defval);
      };
    private:
      akaxiso::member_operator *op_;
    };

  protected:
    static attribute_info attribute_info_;
    static typeinfo typeinfo_;
  };
  
  template<class T>
  attribute_info base_impl<T>::attribute_info_;
  template<class T>
  typeinfo base_impl<T>::typeinfo_;


  template<class prefix_tag>
  void initialize_namespace(const prefix_tag &tag = prefix_tag()) {
    namespaces().register_namespace_uri(tag.uri()); 
    static_global_attributes().associate_namespace_prefix(tag.prefix(), tag.uri()); 
  }

//   struct no_namespace {
//     const char *prefix() { return ""; }
//     const char *uri() { return ""; }
//   };

}


#endif


