#include "builtin.h"
#include <sstream>

using namespace akaxiso;

void simpletype_member_type_impl<unsigned long>::read_text(element &element, std::istringstream &istm, const global_attributes &gattrs) const{
  long val;
  istm >> val;
  if (istm.fail())
    throw invalid_argument();
  if (val < 0)
    throw invalid_argument();

  unsigned long & v = *get_member_ptr<unsigned long>(element, offset_);
  v = (unsigned long) val;
}

void simpletype_member_type_impl<unsigned long>::set_default_value(const char *defval) {
  long val;
  std::istringstream istm(defval);
  istm >> val;
  if (istm.fail())
    throw invalid_argument();
  if (val < 0)
    throw invalid_argument();
  default_ = val;
  has_default_ = true;
}

void simpletype_member_type_impl<std::string>::read_text(element &element, std::istringstream &istm, const global_attributes &gattrs) const{
  std::string &str = *get_member_ptr<std::string>(element, offset_);
  str = istm.rdbuf()->str();
}

void simpletype_member_type_impl<std::string>::set_default_value(const char *defval) {
  default_ = defval;
  has_default_ = true;
}
