#include "choice.h"

using namespace akaxiso;



const name &item::get_qname() const {return itemtype_.get_qname();}; 
const std::string &item::get_tagname() const { return itemtype_.get_qname().get_name(); }



choice::~choice() {
  delete_and_clear();
}


bool choice::is_equal_to(const element *element) const {
  if (&get_typeinfo() != &element->get_typeinfo())
    throw invalid_argument();
  return info_.is_equal(*this, static_cast<const choice&>(*element));
}

void choice::copy_to(element *element) const {
  if (&get_typeinfo() != &element->get_typeinfo())
    throw invalid_argument();
  info_.copy(static_cast<choice&>(*element), *this);
}



void choice::push_back(element *item, const name &qname) {
  insert(end(), item, qname);
} 

void choice::push_back(element * item, const std::string &rawname){
  name name;
  name.set_name(rawname);
  push_back(item, name);
}

choice::iterator choice::erase(iterator it) {
  return items_.erase(it);
}

choice::iterator choice::erase(iterator first, iterator last) {
  return items_.erase(first, last);
}

void choice::insert(iterator it, element *elm, const name &qname) {
  choice_info::const_iterator tit = info_.find(qname);
  if (tit == info_.end()) // Check tag.
    throw invalid_argument();

  if (& tit->second->get_typeinfo() != &elm->get_typeinfo()) // Check class of element instance.
    throw invalid_argument();

  item item(elm, *tit->second);
  items_.insert(it, item);
}

void choice::insert(iterator it, element *item, const std::string &rawname) {
  name name;
  name.set_name(rawname);
  insert(it, item, name);
}

void choice::insert(element *pos , element *elm, const name &qname) {
  iterator it = find_iterator(pos);
  insert(it, elm, qname);
}

void choice::insert(element *pos, element *elm, const std::string &rawname) {
  iterator it = find_iterator(pos);
  insert(it, elm, rawname);
}


choice::iterator choice::find_iterator(element *item) {
  for (iterator it = begin(); it != end(); ++it) {
    if (it->get_element() == item)
      return it;
  }
  return end();
}


size_t choice::size() const {
  return items_.size();
}

void choice::get_elementlist(const std::string &tagname, elementlist &el) {
  name name;
  name.set_name(tagname);
  for (container::iterator it = items_.begin(); it != items_.end(); ++it )
    if (it->get_qname() == name)
      el.push_back(it->get_element());
}

void choice::get_elementlist(const std::string &tagname, elementlist_const &el) const{
  name name;
  name.set_name(tagname);
  for (container::const_iterator it = items_.begin(); it != items_.end(); ++it )
    if (it->get_qname() == name)
      el.push_back(it->get_element());
}

void choice::clear() {
  items_.clear();
}

void choice::delete_and_clear() {
  for (container::iterator it = items_.begin(); it != items_.end(); ++it)
    delete it->get_element();
  clear();
}


// Type identifier-related members.
baseclass_id choice::get_baseclass_id() const {
  return choice_id;
}

const choice_info &choice::get_choice_info() const {
  return info_;
}


//
// choice_info
//

void choice_info::register_itemtype(const itemtype *type) {
  std::pair<itemtype_map::iterator, bool> res = 
    itemtypes_.insert(itemtype_map::value_type(type->get_qname(), type));
  if (!res.second)
    throw invalid_argument();
}


void choice_info::initialize_instance(choice &cho) const {
  
}


bool choice_info::is_equal(const choice &cho1, const choice &cho2) const {
  if (&cho1.get_typeinfo() != &cho2.get_typeinfo())
    return false;

  if (cho1.size() != cho2.size())
    return false;

  choice::const_iterator it1 = cho1.begin();
  choice::const_iterator it2 = cho2.begin();

  while (it1 != cho1.end()) {
    if (&it1->get_itemtype() != &it2->get_itemtype())
      return false;
    bool equal = it1->get_element()->is_equal_to(it2->get_element());
    if (!equal)
      return false;
    ++it1; ++it2;
  }
  return true;
}


void choice_info::copy(choice &dst, const choice &src) const{
  if (&dst.get_typeinfo() != &src.get_typeinfo())
    throw invalid_argument();

  for (choice::const_iterator it = src.begin();
       it != src.end(); ++it) {
    element *e = it->get_element()->replicate_element();
    dst.push_back(e, it->get_qname());
  }
}


void choice_info::clear() {
  itemtypes_.clear();
}

