// -*- c++ -*-
#ifndef AKAXISO_CLASS_IMPL_H__
#define AKAXISO_CLASS_IMPL_H__

#include <akaxiso/classes/builtin.h>
#include <akaxiso/classes/simpletype_impl.h>
#include <akaxiso/classes/simplecontent_impl.h>
#include <akaxiso/classes/sequence_impl.h>
#include <akaxiso/classes/choice_impl.h>
#include <akaxiso/classes/memberarray_impl.h>
#include <akaxiso/classes/attribute_membertype.h>
#include <akaxiso/classes/document_impl.h>

namespace akaxiso {

  inline member_operator *create_member_type(const float&, const float&, int offset) { return new simpletype_member_type_impl<float>(offset);}
  inline member_operator *create_member_type(const double&, const double&, int offset) { return new simpletype_member_type_impl<double>(offset);}
  inline member_operator *create_member_type(const long&, const long&, int offset) { return new simpletype_member_type_impl<long>(offset);}
  inline member_operator *create_member_type(const short&, const short&, int offset) { return new simpletype_member_type_impl<short>(offset);} 
  inline member_operator *create_member_type(const std::string &, const std::string &, int offset) { return new simpletype_member_type_impl<std::string>(offset);}
  inline member_operator *create_member_type(const unsigned long &, const unsigned long &, int offset)  { return new simpletype_member_type_impl<std::string>(offset);}


  template<class V>
  inline member_operator *create_member_type(const sequence&, const V&, int offset) { return new sequence_member_type_impl<V>(offset);} 

  template<class V>
  inline member_operator *create_member_type(const choice&, const V&, int offset) { return new choice_member_type_impl<V>(offset);} 

  template<class V>
  inline member_operator *create_member_type(const simpletype&, const V&, int offset) { return new simpletype_member_type_impl<V>(offset);} 

  template<class V>
  inline member_operator *create_member_type(const simplecontent&, const V&, int offset) { return new simplecontent_member_type_impl<V>(offset);} 

  template<class V>
  inline member_operator *create_member_type(const memberarray&, const V&, int offset) { return new memberarray_member_type_impl<V>(offset);} 

  template<class P, class T, class V>
  inline member_operator* create_member_operator(const P *, V T::* m) {
    int offset = get_member_offset<P, T, V>(m);
    V *v = NULL;
    return create_member_type(*v, *v, offset);
  }


  inline member_operator *create_attribute_type(const float&, const float&, int offset) { return new simpletype_member_type_impl<float>(offset);}
  inline member_operator *create_attribute_type(const double&, const double&, int offset) { return new simpletype_member_type_impl<double>(offset);}
  inline member_operator *create_attribute_type(const long&, const long&, int offset) { return new simpletype_member_type_impl<long>(offset);}
  inline member_operator *create_attribute_type(const short&, const short&, int offset) { return new simpletype_member_type_impl<short>(offset);} 
  inline member_operator *create_attribute_type(const std::string &, const std::string &, int offset) { return new simpletype_member_type_impl<std::string>(offset);}
  inline member_operator *create_attribute_type(const unsigned long &, const unsigned long &, int offset) 
  { return new simpletype_member_type_impl<unsigned long>(offset); }
  template<class V>
  inline member_operator *create_attribute_type(const simpletype&, const V&, int offset) { return new simpletype_member_type_impl<V>(offset);} 

  template<class P, class T, class V>
  inline member_operator* create_attribute_operator(const P *, V T::* m) {
    int offset = get_member_offset<P, T, V>(m);
    V *v = NULL;
    simpletype_member_type *memtype = static_cast<simpletype_member_type*>(create_attribute_type(*v, *v, offset));
    return new attribute_member_type(memtype);
  }

}


#endif
