// -*- c++ -*-
#ifndef AKAXISO_ELEMENT_H__
#define AKAXISO_ELEMENT_H__

#include <akaxiso/classes/name.h>
#include <akaxiso/classes/typeinfo.h>

namespace akaxiso {

  class attribute_info;

  enum baseclass_id {
    simpletype_id = 1,
    simplecontent_id,
    sequence_id,
    choice_id,
    memberarray_id
  };

  class element { 
  public:
    virtual ~element(){};
    virtual bool is_equal_to(const element *element) const = 0;
    virtual void copy_to(element *element) const  = 0;
    virtual const typeinfo &get_typeinfo() const = 0;
    virtual element* replicate_element() const = 0;
    virtual baseclass_id get_baseclass_id() const = 0;

    virtual const attribute_info &get_attribute_info() const = 0;
  };

}


#endif
