// -*- c++ -*-
#ifndef AKAXISO_ELEMENTLIST_H__
#define AKAXISO_ELEMENTLIST_H__

#include <akaxiso/classes/refiterator.h>

namespace akaxiso {


  template<class E>
  class elementlist_base_impl {
  protected:
    elementlist_base_impl() {}
  public:
    enum { this_class_derives_from_the_elementlist_impl};
    typedef E element_type;
    typedef std::list<E*> container;

    typedef refiterator<typename container::iterator, E> iterator;
    typedef const_refiterator<typename container::const_iterator, 
      typename container::iterator, E> const_iterator;

    iterator begin() {
      return iterator(container_.begin());
    }
    iterator end() {
      return iterator(container_.end());
    }
    const_iterator begin() const {
      return const_iterator(container_.begin());
    }
    const_iterator end() const {
      return const_iterator(container_.end());
    }

    bool empty() const {
      return container_.empty();
    }
    size_t size() const {
      return container_.size();
    }


    E& operator[](int index);
    const E& operator[](int index) const;

    void push_back(E* e) {
      container_.push_back(e);
    }

  private:
    container container_;
  };


  class choice;

  template<class E>
  class elementlist_impl : public elementlist_base_impl<E> { 
    friend class choice;
  };

  template<class E>
  class const_elementlist_impl : public elementlist_base_impl<const E> { 
    friend class choice;
  };

}

#endif
