/* -*- c++ -*- */
#ifndef AKAXISO_MEMBERARRAY_H__
#define AKAXISO_MEMBERARRAY_H__

#include <akaxiso/classes/element.h>
#include <akaxiso/classes/membertypes.h>
#include <akaxiso/classes/name.h>

#include <vector>

namespace akaxiso {

  class memberarray {
  protected:
    typedef std::vector<element*> container_type;
    container_type container_;
  public:
    virtual ~memberarray() {}
    typedef container_type::iterator iterator;
    typedef container_type::const_iterator const_iterator;

    iterator begin() { return container_.begin(); }
    iterator end() { return container_.end(); }

    const_iterator begin() const { return container_.begin(); }
    const_iterator end() const { return container_.end(); }
    
    void push_back(element *elm);
    bool empty() const { return container_.empty(); }
    size_t size() const { return container_.size(); }

    void clear();

    virtual const typeinfo &get_value_typeinfo() const = 0;
    virtual element *create_element() const = 0;

  };
  
  
}

#endif
