/* -*- c++ -*- */
#ifndef AKAXISO_REFITERATOR_H__
#define AKAXISO_REFITERATOR_H__


namespace akaxiso {
  template<class It, class E>
  class refiterator : public std::iterator<std::bidirectional_iterator_tag, E> {
  public:
    typedef refiterator<It, E> this_type;

    refiterator() {}
    refiterator(const this_type &it) : it_(it.it_) {}
    refiterator(const It &it) : it_(it) {}

    this_type operator++(){ return ++it_; }
    this_type operator++(int){ return it_++;}
    this_type operator--(){ return --it_;}
    this_type operator--(int){ return it_--;}

    E* operator->(){ return static_cast<E*>(*it_); }
    E& operator*(){ return static_cast<E&>(**it_);}

    const this_type &operator=(const this_type &rhs);

    friend bool operator==(const this_type &it1, const this_type &it2) { return it1.it_ == it2.it_; }
    friend bool operator!=(const this_type &it1, const this_type &it2) { return it1.it_ != it2.it_; }

  private:
    It it_;
  };

  template<class Cit, class It, class E>
  class const_refiterator : public std::iterator<std::bidirectional_iterator_tag, const E> {
  public:
    typedef const_refiterator<Cit, It, E> this_type;

    const_refiterator() {}
    const_refiterator(const Cit &it) : it_(it) {}
    const_refiterator(const It &it) : it_(it) {}
    const_refiterator(const this_type &it) : it_(it.it_) {}
    const_refiterator(const refiterator<It, E>  &it) : it_(it.it_) {}


    this_type operator++(){ return ++it_; }
    this_type operator++(int){ return it_++;}
    this_type operator--(){ return --it_;}
    this_type operator--(int){ return it_--;}

    const E* operator->() const { return static_cast<const E*>(*it_); }
    const E& operator*() const { return static_cast<const E&>(**it_);}

    const this_type &operator=(const this_type &rhs);

    friend bool operator==(const this_type &it1, const this_type &it2) { return it1.it_ == it2.it_; }
    friend bool operator!=(const this_type &it1, const this_type &it2) { return it1.it_ != it2.it_; }

  private:
    Cit it_;
  };

}

#endif
