/* -*- c++ -*- */
#ifndef AKAXISO_SIMPLECONTENT_H__
#define AKAXISO_SIMPLECONTENT_H__

#include <akaxiso/classes/element.h>
#include <akaxiso/classes/attributeinfo.h>
#include <akaxiso/classes/simpletype.h>
#include <akaxiso/classes/global_attributes.h>

namespace akaxiso {

  class simplecontent : public element {
  public:
    virtual baseclass_id get_baseclass_id() const;

    virtual void write_text(std::ostream &ostm, const global_attributes &gattrs) const = 0;
    virtual bool read_text(std::istringstream &istm, const global_attributes &gattrs) = 0;
  };


  class null_value : public simpletype {
  public:
    void write_text(std::ostream &ostm, const global_attributes &gattrs) const {}
    bool read_text(std::istringstream &istm, const global_attributes &gattrs) { return true; }
    bool is_equal_to(const null_value &rhs) const { return true; }
    void copy_to(const null_value &rhs) const {  }
  };

}


#endif
