#include "memberarray_handler.h"
#include "sequence_handler.h"
#include "choice_handler.h"
#include "../classes/choice.h"
#include "simplecontent_handler.h"
#include "../classes/simplecontent.h"
#include "../classes/memberarray.h"

#include <cassert>

using namespace akaxiso;
  
memberarray_handler::memberarray_handler(memberarray *ma, 
					 const member_info &meminfo, 
					 handlers &handlers, 
					 const locator *locator) 
  : handler(handlers, locator), ma_(ma), meminfo_(meminfo) {
}


void memberarray_handler::query_element(const name &qname, const attributes &attrs, const global_attributes &gattrs) {

  if (meminfo_.get_qname() != qname) 
    throw parse_exception(__FILE__, __LINE__, locator_->get_position());

  element *e = ma_->create_element();

  handler *handler = NULL;
  switch (e->get_baseclass_id()) {
  case sequence_id: {
    handler = new sequence_handler(static_cast<sequence*>(e), handlers_, locator_);
    break;
  }
  case choice_id: {
    handler = new choice_handler(static_cast<choice*>(e), handlers_, locator_);
    break;
  }
  case simplecontent_id: {
    handler = new simplecontent_handler(static_cast<simplecontent*>(e), handlers_, locator_);
    break;
  }
  case simpletype_id:
  default:
    assert(!"Must not reach here.");
  }

  handlers_.push(handler);
}


void memberarray_handler::prepare_element(const name &qname, const attributes &attrs, const global_attributes &gattrs) {
}

void memberarray_handler::end_element(const name &qname) {
}


void memberarray_handler::parse_entity(const std::string &entity) {
  
}

element* memberarray_handler::get_element() {
  return NULL;
}

void memberarray_handler::receive_child(element *e) {
  ma_->push_back(e);
}


bool memberarray_handler::rollup() const {
  return true;
}
