#include "simplecontent_handler.h"
#include "sequence_handler.h"
#include "simplecontent_handler.h"
#include "../classes/choice.h"
#include "../classes/simplecontent.h"

#include <cassert>
#include <sstream>

using namespace akaxiso;
  
simplecontent_handler::simplecontent_handler(simplecontent *sim, handlers &handlers, const locator *locator) 
  : handler(handlers, locator), sim_(sim) {
}


void simplecontent_handler::query_element(const name &qname, const attributes &attrs, const global_attributes &gattrs) {
  assert(!"Must not be called.");
}


void simplecontent_handler::prepare_element(const name &qname, const attributes &attrs, const global_attributes &gattrs) {
  gattrs_ = &gattrs;
}



void simplecontent_handler::end_element(const name &qname) {
}


void simplecontent_handler::parse_entity(const std::string &entity) {
  std::istringstream istm(entity);
  bool res = sim_->read_text(istm, *gattrs_);
  assert(res);
}

element* simplecontent_handler::get_element() {
  return sim_;
}

void simplecontent_handler::receive_child(element *e) {
  assert(!"Must not be called.");
}

bool simplecontent_handler::rollup() const {
  return false;
}
