// -*- c++ -*-

#ifndef AKAXISO_SERIALIZER_H__
#define AKAXISO_SERIALIZER_H__


#include <akaxiso/classes/types.h>

namespace akaxiso {
  class document;

  class serializer  {
  public:
    serializer() : indent_(0), indent_str_("    ") {}
    virtual ~serializer(){};
    virtual void serialize(const document *doc, std::ostream &ostm) = 0;
    
  protected:
    int indent_;
    void inc_indent_level() { ++indent_; }
    void dec_indent_level() { -- indent_; }
    void new_line(std::ostream &ostm);
    std::string indent_str_;
  };
  
}

#endif  // ifdef AKAXISO_SERIALIZER
