// -*- c++ -*-
#ifndef AKAXISO_YGG_PARSER_H__
#define AKAXISO_YGG_PARSER_H__

#include <akaxiso/classes/document.h>
#include <akaxiso/parser.h>

namespace akaxiso {

  class ygg_parser : public parser {
  public:
    virtual document *parse(std::istream &stm) = 0;
    document *parse_stdin();
    document *parse(const char *document);
    document *parse(const std::string &document);
  };


  class yggsox_parser : public ygg_parser {
  public:
    virtual document *parse(std::istream &stm);
    virtual document *parse_stdin() { return ygg_parser::parse_stdin(); }
    virtual document *parse(const char *document) { return ygg_parser::parse(document); }
    virtual document *parse(const std::string &document) { return ygg_parser::parse(document); }
  };


  class yggxml_parser : public ygg_parser {
  public:
    virtual document *parse(std::istream &stm);
    virtual document *parse_stdin() { return ygg_parser::parse_stdin(); }
    virtual document *parse(const char *document) { return ygg_parser::parse(document); }
    virtual document *parse(const std::string &document) { return ygg_parser::parse(document); }
  };

}

#endif
