/* -*- c++ -*- */
#ifndef CLASSCONTENTS_H__
#define CLASSCONTENTS_H__

#include "schemastructure.h"
#include <set>

namespace osixaka {

  class class_contents {
  public:
    virtual ~class_contents(){}
    virtual void generate_header(std::ostream &ostm) const = 0;
    virtual void generate_implementation(std::ostream &ostm) const = 0;

    bool has_dependent_classes() const {
      return !depclasses_.empty();
    }
    void remove_dependency(const std::string classname) {
      depclasses::iterator it = depclasses_.find(classname);
      if (it != depclasses_.end())
      depclasses_.erase(it);
    }

    akaxiso::name name_;
  protected:
    typedef std::set<std::string> depclasses;
    depclasses depclasses_;
  };


  class class_contents_container {
  public:
    typedef std::map<akaxiso::name, class_contents*, akaxiso::name_less> contents;
    typedef contents::iterator iterator;
    
    iterator begin() { return contents_.begin(); }
    iterator end() { return contents_.end(); }
    bool empty() const { return contents_.empty(); }

    void add(const akaxiso::name& name, class_contents *contents);
    class_contents *get(const akaxiso::name &name);

    bool exists(const akaxiso::name &name) const;

    void remove_class_contents(const class_contents *contents);


  private:
    contents contents_;
  };


  /* Sequence */
  class sequence_member {
  public:
    sequence_member() : minOccurs_(1), maxOccurs_(1){}

    std::string name_;
    std::string type_;

    unsigned long minOccurs_;
    xml_schema::maxOccurs_type maxOccurs_;

    bool is_array() const {
      return (minOccurs_ != 1) || (maxOccurs_ != 1);
    }

  };


  typedef std::vector<sequence_member> sequence_members;

  class sequence_class : public class_contents {
  public:
    virtual ~sequence_class() {}
    virtual void generate_header(std::ostream &ostm) const;
    virtual void generate_implementation(std::ostream &ostm) const;
    
    void push_membertype(const sequence_member &mt, bool simpletype) {
      members_.push_back(mt);
      if (!simpletype)
	depclasses_.insert(mt.type_);
    }
    
  private:
    sequence_members members_;
  };


  /** Choice */
  class choice_item {
  public:
    choice_item() : minOccurs_(1), maxOccurs_(1){}
    std::string name_;
    std::string type_;
    unsigned long minOccurs_;
    xml_schema::maxOccurs_type maxOccurs_;

    bool is_default_occurence() const {
      return (minOccurs_ != 1) || (maxOccurs_ != 1);
    }

  };

  typedef std::vector<choice_item> choice_items;

  class choice_class : public class_contents {
  public:
    virtual void generate_header(std::ostream &ostm) const;
    virtual void generate_implementation(std::ostream &ostm) const;

    void push_itemtype(const choice_item &item) {
      items_.push_back(item);
      depclasses_.insert(item.type_);
    }

  private:
    choice_items items_;
  };


  class simplecontent_class : public class_contents {
  public:
    std::string value_type_;
    virtual void generate_header(std::ostream &ostm) const;
    virtual void generate_implementation(std::ostream &ostm) const;
  };


  class document_class : public class_contents {
  public:
    std::string root_name_;
    virtual void generate_header(std::ostream &ostm) const;
    virtual void generate_implementation(std::ostream &ostm) const;
  };

}


#endif
