/* -*- c++ -*- */
#ifndef AKAXISO_CLASSGEN_H__
#define AKAXISO_CLASSGEN_H__

#include "schemastructure.h"
#include "classcontents.h"
#include "type_registory.h"


namespace osixaka {


  
  class generator {
  private:
    typedef akaxiso::elementlist_impl<const xml_schema::GlobalElement> GlobalElementList;
    typedef akaxiso::elementlist_impl<const xml_schema::Element> ElementList;
    typedef akaxiso::elementlist_impl<const xml_schema::ComplexType> ComplexTypeList; 

    std::string element_fn_;
    std::string document_fn_;
    std::string setup_header_;
    std::string setup_impl_;

    class_contents_container contents_;
    class_contents_container documents_;

    type_registory type_registory_;
    std::string resolve_typename(const akaxiso::name &name);

    static void write_header(std::ostream &ostm, const std::string &filename);
    static void write_footer(std::ostream &ostm, const std::string &filename);
    static std::string get_filesig(const std::string &filename);


    /** Top-level element */
    void generate_global_elements(const GlobalElementList &gel);

    /** Top-level complexType */
    void generate_global_complexTypes(const ComplexTypeList &cel);
    /** complexType in element declarations */
    void generate_complexType(const xml_schema::ComplexType &ct, const xml_schema::name &name);

    /** Particles */
    void generate_sequence(const xml_schema::Sequence &seq, const akaxiso::name &name);
    void generate_choice(const xml_schema::Choice &cho, const akaxiso::name &name);

    /* simpletypes */
    void generate_simpletype_wrapper(const akaxiso::name &name, const std::string &cppname);


  public:
    generator() 
      : element_fn_("elements.h"),
	document_fn_("documents.h"),
	setup_header_("setup.h"),
	setup_impl_("setup.cpp")    {
    }

    int generate_classes(xml_schema::SchemaDoc *doc);
    void output_document_file(std::ostream &ostm);
    void output_element_file(std::ostream &ostm);
    void output_setup_file(std::ostream &header, std::ostream &impl);

    void set_filenames(const std::string &element_fn, const std::string &document_fn, 
		       const std::string &setup_header, const std::string &setup_impl) {
      element_fn_ = element_fn;
      document_fn_ = document_fn;
      setup_header_ = setup_header;
      setup_impl_ = setup_impl;
    }
  };
  
}

#endif
