/* -*- c++ -*- */
#ifndef ADOM_SCHEMADOC_HPP__
#define ADOM_SCHEMADOC_HPP__

#include "schemadatatypes.h"
#include <sstream>

namespace xml_schema {


  class maxOccurs_type : public akaxiso::simpletype {
  public:
    maxOccurs_type() : value_(1){}
    maxOccurs_type(unsigned int value) : value_(value){}

    bool read_text(std::istringstream &istm, const akaxiso::global_attributes &gattrs);
    void write_text(std::ostream &ostm, 
		    const akaxiso::global_attributes &gattrs  = akaxiso::static_global_attributes()) const;
    bool is_equal_to(const maxOccurs_type &rhs) const { return *this == rhs; }
    void copy_to(maxOccurs_type &rhs) const { rhs = *this; }
    int get_value() const { return value_; }

    bool is_unbounded() const { return value_ == akaxiso::unbounded; }


    bool operator==(const maxOccurs_type &occ) const { return value_ == occ.value_; }
    bool operator!=(const maxOccurs_type &occ) const { return value_ != occ.value_; }

    
    const maxOccurs_type& operator=(const maxOccurs_type &rhs) {
      if (this == &rhs)
	return *this;
      *this = (rhs.value_);
      return *this;
    }

    const maxOccurs_type &operator=(std::string &rhs) {
      if (rhs == "unbounded") {
	value_ = akaxiso::unbounded;
	return *this;
      }
      std::istringstream istm(rhs);
      istm >> value_;
      if (istm.fail())
	throw akaxiso::invalid_argument();
      return *this;
    }

    const maxOccurs_type &operator=(const unsigned int rhs) {
      value_ = rhs;
      return *this;
    }

  private:
    int value_;
  };




  class name : public akaxiso::name,
	       public akaxiso::simpletype {
  public:
    bool read_text(std::istringstream &istm, const akaxiso::global_attributes &gattrs);
    void write_text(std::ostream &ostm, const akaxiso::global_attributes &gattrs) const;
    bool is_equal_to(const name &rhs) const {
      return static_cast<const akaxiso::name&>(*this) == static_cast<const akaxiso::name&>(rhs);
    }
    void copy_to(name &rhs) const {
      static_cast<akaxiso::name&>(rhs) = static_cast<const akaxiso::name&>(*this);
    }
    bool empty() const { return get_name().empty(); }

    friend std::ostream &operator<<(std::ostream &ostm, const name &rhs) {
      ostm << rhs.get_name();
      return ostm;
    }
  };






  class ComplexType;
  typedef akaxiso::memberarray_impl<ComplexType> ComplexTypes;

  class Element : public akaxiso::sequence_impl<xml_schema::Element> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("xsd:element");
      define_member("xsd:complexType", &Element::complexTypes_);// OCCURENCE(0, 1);
      define_attribute("name", &Element::name_).set_default_value("");
      define_attribute("type", &Element::type_).set_default_value("");
      define_attribute("ref", &Element::ref_).set_default_value("");
      define_attribute("minOccurs", &Element::minOccurs_).set_default_value("1");
      define_attribute("maxOccurs", &Element::maxOccurs_).set_default_value("1");
    }

    name name_;
    name type_;
    name ref_;
    unsigned long minOccurs_;
    maxOccurs_type maxOccurs_;
    
    ComplexTypes complexTypes_;
  };

  class GlobalElement : public akaxiso::sequence_impl<xml_schema::GlobalElement> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("xsd:global_element");
      define_member("xsd:complexType", &GlobalElement::complexTypes_);// OCCURENCE(0, 1);
      define_attribute("name", &GlobalElement::name_).set_default_value("");
      define_attribute("type", &GlobalElement::type_).set_default_value("");
    }
    
    name name_;
    name type_;
    
    ComplexTypes complexTypes_;
  };


  class Attribute : public akaxiso::simplecontent_impl<Attribute, akaxiso::null_value> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("xsd:attribute");
      define_attribute("name", &Attribute::name_).set_default_value("");
      define_attribute("type", &Attribute::type_).set_default_value("");
    }

    name name_;
    name type_;
  };

  typedef akaxiso::memberarray_impl<Element> Elements;
  typedef akaxiso::memberarray_impl<Attribute> Attributes;

  class Sequence : public akaxiso::sequence_impl<Sequence> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("xsd:sequence");
      define_member("xsd:element", &Sequence::elements_);
      define_member("xsd:attribute", &Sequence::attributes_);
    }

    Elements elements_;
    Attributes attributes_;
  };

  class Choice : public akaxiso::choice_impl<Choice> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("xsd:choice");
      define_item(element());
    }
    struct element : public akaxiso::itemtype_impl<element, xml_schema::Element> {
      const char *get_tagname() const { return "xsd:element"; }
    };
//     ITEMTYPE(sequence, xml_schema::Sequence)
//     ITEMTYPE(choice, xml_schema::Choice)
  };

  class ComplexType : public akaxiso::choice_impl<ComplexType> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("xsd:complexType");
      define_item(element());
      define_item(sequence());
      define_item(choice());
      define_item(attribute());
      define_attribute("name", &ComplexType::name_).set_default_value("");
    }
      
    struct element : public akaxiso::itemtype_impl<element, xml_schema::Element> {
      const char *get_tagname() const { return "xsd:element"; }
    };
    struct sequence : public akaxiso::itemtype_impl<sequence, xml_schema::Sequence> {
      const char *get_tagname() const { return "xsd:sequence"; }
    };
    struct choice : public akaxiso::itemtype_impl<choice, xml_schema::Choice> {
      const char *get_tagname() const { return "xsd:choice"; }
    };
    struct attribute : public akaxiso::itemtype_impl<attribute, xml_schema::Attribute> {
      const char *get_tagname() const { return "xsd:attribute"; }
    };

    name name_;
  };

  class Schema : public akaxiso::choice_impl<Schema> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("xsd:schema");
      define_item(complexType());// OCCURENCE(0, akaxiso::unbounded)
      define_item(element());// OCCURENCE(0, akaxiso::unbounded)
    }

    struct complexType : public akaxiso::itemtype_impl<complexType, xml_schema::ComplexType> {
      const char *get_tagname() const { return "xsd:complexType"; }
    };
    struct element : public akaxiso::itemtype_impl<element, xml_schema::GlobalElement> {
      const char *get_tagname() const { return "xsd:element"; }
    };
    //       ITEM(simpleType)
    //       ITEM(group)
    // ITEM(attributeGroup)
    // redefinable end.
    //      ITEM(attribute)
    //      ITEM(notation)
//     ITEMTYPE(group, Group);
//     ITEMTYPE(simpleType, SimpleType);
  };

  class SchemaDoc : public akaxiso::document_impl<SchemaDoc, Schema> {
  public:
    static void initialize_types() {
      define_document("xsd:schema");
    }
  };

  void initialize();
  void uninitialize();
  
} 


#endif
