#include "setup.h"


#include "elements.h"
#include "documents.h"

void Comment::initialize_types() {
  static_typeinfo().set_typename("Comment");
}

void Constituent::initialize_types() {
  static_typeinfo().set_typename("Constituent");

  define_item(tagDate());
  define_item(tagTitle());
  define_item(tagComment());
}

void Constituents::initialize_types() {
  static_typeinfo().set_typename("Constituents");

  define_member("Constituent", &Constituents::Constituents_);// OCCURENCE(0, akaxiso::unbounded)

};

void Date::initialize_types() {
  static_typeinfo().set_typename("Date");
}

void Title::initialize_types() {
  static_typeinfo().set_typename("Title");
}

void Todo::initialize_types() {
  static_typeinfo().set_typename("Todo");

  define_member("Constituents", &Todo::Constituents_);

};

void Constituent_doc::initialize_types() {
  define_document("Constituent");
}

void Constituents_doc::initialize_types() {
  define_document("Constituents");
}

void Todo_doc::initialize_types() {
  define_document("Todo");
}


void initialize() {

  Comment::initialize();
  Constituent::initialize();
  Constituents::initialize();
  Date::initialize();
  Title::initialize();
  Todo::initialize();
  Constituent_doc::initialize();
  Constituents_doc::initialize();
  Todo_doc::initialize();

}

void uninitialize() {

  Comment::uninitialize();
  Constituent::uninitialize();
  Constituents::uninitialize();
  Date::uninitialize();
  Title::uninitialize();
  Todo::uninitialize();
  Constituent_doc::uninitialize();
  Constituents_doc::uninitialize();
  Todo_doc::uninitialize();

}

