#include "platform.h"
#include "type_registory.h"
#include "schemastructure.h"
#include "classgen.h"
#include "exception.h"

#include <iostream>


namespace {

  struct type {
    const char *uri;
    const char *name;
    const char *cppname;
  };
   
  const type types[] = {
    {NS_XMLSCHEMA, "float", "float"},
    {NS_XMLSCHEMA, "double", "double"},
    {NS_XMLSCHEMA, "short", "short"},
    {NS_XMLSCHEMA, "int", "long"},
    {NS_XMLSCHEMA, "string", "std::string"},
    {NULL, NULL, NULL}
  };

}

using namespace osixaka;
namespace aka = akaxiso;




const std::string &type_names::get(const aka::name &name) const {
  
  static std::string str;
  transmap_type::const_iterator it = transmap_.find(name);
  if (it == transmap_.end()) {
    std::cerr << "not found." << std::endl;
    return str;
  }
  return it->second;
}

bool type_names::exists(const aka::name &name) const {
  transmap_type::const_iterator it = transmap_.find(name);
  return (!(it == transmap_.end()));
}


void type_names::insert(const akaxiso::name &name, const std::string &cppname) {
  std::pair<transmap_type::iterator, bool> res = transmap_.insert(transmap_type::value_type(name, cppname));
  if (!res.second)
    throw osixaka::fatal_error(__FILE__, __LINE__, "typename registration failed.");
}


simpleType_names::simpleType_names() {
  initialize();
}

void simpleType_names::initialize() {
  for (const type *ty = types; ty->uri != NULL; ++ty) {
    aka::name name;
    name.set_name(ty->uri, ty->name);
    transmap_.insert(transmap_type::value_type(name, ty->cppname));
  }
}



/** type_registory */
void type_registory::insert_simpleType(const akaxiso::name &name, const std::string &cppname) {
  simpleType_names_.insert(name, cppname);
}

const std::string &type_registory::get_simpleType(const akaxiso::name &name) const{
  return simpleType_names_.get(name);
}

bool  type_registory::simpleType_exists(const akaxiso::name &name) const{
  return simpleType_names_.exists(name);
}


void type_registory::insert_complexType(const akaxiso::name &name, const std::string &cppname) {
  complexType_names_.insert(name, cppname);
}

const std::string &type_registory::get_complexType(const akaxiso::name &name) const{
  return complexType_names_.get(name);
}

bool  type_registory::complexType_exists(const akaxiso::name &name) const{
  return complexType_names_.exists(name);
}


void type_registory::insert_element(const akaxiso::name &name, const std::string &cppname) {
  element_names_.insert(name, cppname);
}

const std::string &type_registory::get_element(const akaxiso::name &name) const{
  return element_names_.get(name);
}

bool  type_registory::element_exists(const akaxiso::name &name) const{
  return element_names_.exists(name);
}


const std::string &type_registory::get_type(const akaxiso::name &name) const {
  if (simpleType_exists(name))
    return get_simpleType(name);
  if (complexType_exists(name))
    return get_complexType(name);

  std::ostringstream ostm;
  ostm << "name of type(" << name.get_name() << ") not found.";
  throw fatal_error(__FILE__, __LINE__, ostm.rdbuf()->str().c_str());
}

bool  type_registory::type_exists(const akaxiso::name &name) const {
  if (simpleType_exists(name))
    return true;
  return complexType_exists(name);
}

