/* -*- c++ -*- */
#ifndef TYPE_REGISTORY_H__
#define TYPE_REGISTORY_H__

#include <map>
#include <akaxiso/akaxiso.h>

namespace osixaka {

  class type_names {
  public:
    typedef std::map<akaxiso::name, std::string, akaxiso::name_less> transmap_type;
    const std::string& get(const akaxiso::name &xmlname) const;
    bool exists(const akaxiso::name &name) const;
    void insert(const akaxiso::name &name, const std::string &cppname);
  protected:
    transmap_type transmap_;
  };

  class simpleType_names : public type_names {
  public:
    simpleType_names();
  private:
    void initialize(); // for C++ native typenames.
  };


  class type_registory {
  public:
    void insert_simpleType(const akaxiso::name &name, const std::string &cppname);
    const std::string &get_simpleType(const akaxiso::name &name) const;
    bool  simpleType_exists(const akaxiso::name &name) const;

    void insert_complexType(const akaxiso::name &name, const std::string &cppname);
    const std::string &get_complexType(const akaxiso::name &name) const;
    bool complexType_exists(const akaxiso::name &name) const;

    void insert_element(const akaxiso::name &name, const std::string &cppname);
    const std::string &get_element(const akaxiso::name &name) const; // element
    bool element_exists(const akaxiso::name &name) const;

    // described in @type attributes.
    const std::string &get_type(const akaxiso::name &name) const;
    bool  type_exists(const akaxiso::name &name) const;

  private:
    simpleType_names simpleType_names_;
    type_names complexType_names_;
    type_names element_names_;
  };
  
}

#endif
