// -*- c++ -*-
#ifndef ADDRESSBOOK_H__
#define ADDRESSBOOK_H__

#include <akaxiso/akaxiso.h>
#include <akaxiso/macrodefs.h>

namespace ab {

  class Person : public akaxiso::sequence_impl<Person> {
  public:
    AKAXISO_SEQUENCE("person")
      MEMBER("name", name_)
      MEMBER("gender", gender_)
      MEMBER("age", age_);
    AKAXISO_END;

    akaxiso::string name_;
    akaxiso::string gender_;
    long age_;

  };

  class Persons : public akaxiso::choice_impl<Persons> {
  public:
    AKAXISO_CHOICE("persons")
      ITEM(person)
    AKAXISO_END;
    
    ITEMTYPE(person, Person);
  };


  class AddressBook : public akaxiso::document_impl<AddressBook, Persons> {
  public:
    AKAXISO_DOCUMENT("address_book");
  };

  void initialize();
  void uninitialize();

}



#endif
