/* -*- c++ -*- */
#ifndef AKAXISO_ANY_HANDLER_H__
#define AKAXISO_ANY_HANDLER_H__

#include <akaxiso/parser/handler.h>
#include <akaxiso/classes/any.h>

namespace aka2 {

  class any_handler : public handler {
  public:
    any_handler(const qname& tagname, any &an, int depth,
		const element_op& eop, 
		parser_context &context);

    virtual ~any_handler(){}
    virtual parse_result query_element(const qname &tagname, const attribute_values &attrs, 
				       const global_attributes &gattrs);
    virtual parse_result find_particle(const qname &tagname, const attribute_values &attrs, 
				       const global_attributes &gattrs);
    virtual parse_result end_element(const qname &tagname);
    virtual bool parse_entity(const std::string &entity, const global_attributes &gattrs);

    virtual memberpair get_element();
    virtual void receive_child(const memberpair &e);
    virtual bool can_skip();
    virtual void abort(){}
    
  private:
    any &an_;
    const element_op &eop_;
    int any_depth_;
  };
  
  
}

#endif
