/*------------------------------------------------------------------------
 * filename - sys/cdefs.h
 *
 * Compiler compatibility macros for GNU libc.
 *-----------------------------------------------------------------------*/

/*
 *      C/C++ Run Time Library - Version 1.0
 *
 *      Copyright (c) 2002 by Borland Software Corporation
 *      All Rights Reserved.
 *
 */


#ifndef	_BORLAND_SYS_CDEFS_H
#define	_BORLAND_SYS_CDEFS_H

#include <_defs.h>

/*
 * glibc compatibility header, based upon the <sys/cdefs.h> included in
 * mandrake's glibc-devel-2.2.4-9.1 package
 */

#ifndef __BORLANDC__
/*
 * we have internal users that will include this header when
 * compiling with gcc.
 */
#include _STD_HEADER_(sys/cdefs.h)

#else

/*
 * define the same header-guard that the glibc header defines in case
 * anyone in glibc "knows" the header guard.
 */
#define _SYS_CDEFS_H 1

/*
 * ensure <features.h> is included.  
 */
#include <features.h>

/*
 * this is the list of macros we define.  undef them all first:  they're
 * reserved for the implementation, and that's sort of us.
 */

#undef __BEGIN_DECLS
#undef __END_DECLS
#undef __CONCAT
#undef __P
#undef __PMT
#undef __REDIRECT
#undef __STRING
#undef __THROW
#undef __attribute__
#undef __attribute_format_arg__
#undef __attribute_format_strfmon__
#undef __attribute_malloc__
#undef __attribute_pure__
#undef __bounded
#undef __const
#undef __extension__
#undef __flexarr
#undef __inline
#undef __long_double_t
#undef __ptr_t
#undef __ptrvalue
#undef __restrict
#undef __restrict_arr
#undef __signed
#undef __unbounded
#undef __volatile

/*
 * the macros that differ between C++ and C
 */
#ifdef __cplusplus
    #define __BEGIN_DECLS   extern "C" {
    #define __END_DECLS	    }

    /*
     * there is no macro to test for -x (enable exception handling),
     * except #pragma defineonoption doesn't play nicely with trying to
     * compile the preprossed output.  there's also overhead associated
     * with throw() in our implmentation that we don't want.
     */
    #define __THROW
    #define __P(__args)	    __args
    #define __PMT(__args)   __args
    #define __inline	    inline
#else
    #define __BEGIN_DECLS
    #define __END_DECLS
    #define __THROW
    #define __P(__args)	    __args
    #define __PMT(__args)   __args
    #define __inline	    __inline
#endif /* __cplusplus */


/* ansi preprocessor wrappers */
#define __CONCAT(__a,__b)   __a ## __b
#define __STRING(__a)	    #__a

/* GNU __attribute__ wrappers */
#define __attribute__(__x)
#define __attribute_format_arg__(__x)
#define __attribute_format_strfmon__(__x,__y)
#define __attribute_malloc__
#define __attribute_pure__


/* ansi type modifiers */
#define __const		    const
#define __restrict	    /* ISOC99 restrict */
#define __signed	    signed
#define __volatile	    volatile

/* ansi types */
#define __long_double_t	    long double
#define __ptr_t		    void *

/* other gcc extensions */
#define __extension__
#define __flexarr
#define __restrict_arr
#define __bounded
#define __unbounded
#define __ptrvalue	    

#if defined __cplusplus && defined _GLIBCPP_USE_NAMESPACES
# define __BEGIN_NAMESPACE_STD namespace std {
# define __END_NAMESPACE_STD   }
# define __USING_NAMESPACE_STD(name) using std::name;
# define __BEGIN_NAMESPACE_C99 namespace __c99 {
# define __END_NAMESPACE_C99 }
# define __USING_NAMESPACE_C99(name) using __c99::name
#else
# define __BEGIN_NAMESPACE_STD
# define __END_NAMESPACE_STD
# define __USING_NAMESPACE_STD(name)
# define __BEGIN_NAMESPACE_C99
# define __END_NAMESPACE_C99
# define __USING_NAMESPACE_C99(name)
#endif


#endif /* !_BORLAND_SYS_CDEFS_H */
#endif


