/* -*- c++ -*- */
#ifndef AKAXISO_EXCEPTION_H__
#define AKAXISO_EXCEPTION_H__

#include <exception>
#include <string>

namespace aka2 {
  
  struct error : public std::exception {
    error(const std::string &msg, const char *file, const unsigned long line);
    virtual ~error() throw();
    virtual const char *what() const throw();
  private:
    std::string msg_;
  };

  class parse_error : public error {
  public:
    parse_error(const std::string &msg, const char *file, const unsigned long line) :
      error(msg, file, line) {}
    virtual ~parse_error() throw() { };
  };

  struct internal_error{};
}

#endif
