#include "schema_builtin_xiso.h"
#include "../classes/preconditions.h"
#include "../classes/namespaces.h"

namespace xs {

  void QNameLeaf::read_text(void *elm, std::istringstream &istm, 
			    const aka::preconditions &pcd) {
    aka::qname &name = *static_cast<aka::qname*>(elm);
    std::string rawname;
    istm >> rawname;
    name.set(rawname, pcd.get_prefixes());
  }


  void QNameRefLeaf::read_text(void *elm, std::istringstream &istm, 
			       const aka::preconditions &pcd) {
    aka::qname &name = *static_cast<aka::qname*>(elm);
    std::string rawname;
    istm >> rawname;
    if (rawname.find_first_of(':') == std::string::npos)
      name.set(pcd.get_prefixes().get_prefix_id(""), rawname); 
    else
      name.set(rawname, pcd.get_prefixes()); 
  }

}

