#include "xschemaparser.h"

xs::schema *xschemaparser::parse(const std::string &filepath) {
  aka::document doc;
  try {
    if (verbose_)
      ostm_ << "Parsing " << filepath << "..." << std::flush;
    doc = parser_.parse_file(filepath);
    if (verbose_)
      ostm_ << "done." << std::endl;
  }
  catch (const std::exception &e) {
    ostm_ << e.what() << std::endl;
    ostm_ << "Unsupported features or wrong grammar found in schema document." << std::endl
	   << "Aborting..." << std::endl;
    return 0;
  }
  catch ( ... ) {
    ostm_ << "Unhandled parse error detected.  Aborting..." << std::endl;
    return 0;
  }
  
  if (do_dump_) {
    aka::xml_serializer ser;
    try {
      ser.serialize(doc, std::cout);
    }
    catch (const std::exception &e) {
      ostm_ << "Serialization failed." << std::endl
	     << e.what() << std::endl;
    }
  }
  return aka::adopt_root<xs::schema>(doc);
}
