//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include <xercesc/util/PlatformUtils.hpp>

#include <akaxiso/akaxiso.h>
#include <akaxiso/xerces/parser.h>

//CUPPA:namespace=+
//CUPPA:namespace=-


namespace {
  class SimpleTypeSample : public akaxiso::simpletype {
  public:
    bool read_text(std::istringstream &istm, const akaxiso::global_attributes &gattrs) {
      value_ = istm.rdbuf()->str();
      return true;
    };
    void write_text(std::ostream &ostm, const akaxiso::global_attributes &gattrs) const {
      ostm << value_;
    }
    bool is_equal_to(const SimpleTypeSample &rhs) const {
      return value_ == rhs.value_;
    }
    void copy_to(SimpleTypeSample &rhs) const {
      rhs.value_ = value_;
    }

    std::string value_;
  };

  class SeqSample : public akaxiso::sequence_impl<SeqSample> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("sample_sequence");
      define_member("simpletype", &SeqSample::simpletype_);
    }
    SimpleTypeSample simpletype_;
  };

  class MyDoc : public akaxiso::document_impl<MyDoc, SeqSample> {
  public:
    static void initialize_types() {
      define_document("MyDoc");
    }
  };

  void initialize_() {
    SeqSample::initialize();
    MyDoc::initialize();
  }

  void uninitialize_() {
    SeqSample::uninitialize();
    MyDoc::uninitialize();
  }
}


class SimpleTypeTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(SimpleTypeTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test_equality0);
  CPPUNIT_TEST(test_equality1);
  CPPUNIT_TEST(test_copy);
  CPPUNIT_TEST(test_replicate);
  CPPUNIT_TEST(test_serialize);
  CPPUNIT_TEST(test_parse);
//    CPPUNIT_TEST_EXCEPTION(test_wrongSequence0, akaxiso::parseexception);
//    CPPUNIT_TEST_EXCEPTION(test_wrongSequence1, akaxiso::parseexception);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

//    // your stuff...
  MyDoc *doc_;
  MyDoc *doc1_;

public:

  virtual void setUp() { 
//     XMLPlatformUtils::Initialize();
    akaxiso::initialize();
    initialize_();
    doc_ = NULL;
    doc1_ = NULL;
  }

  virtual void tearDown(){
    if (doc_)
      delete doc_;
    if (doc1_)
      delete doc1_;
   
    uninitialize_();
    akaxiso::uninitialize();
//     XMLPlatformUtils::Terminate();
  }


  static void setValues(SeqSample *seq){
    seq->simpletype_.value_ = "Test String for a member in Sequence.";
  }

  static SeqSample* createSample() {
    SeqSample *seq = SeqSample::create();
    setValues(seq);
    return seq;
  }

//CUPPA:decl=+
  void test_typeinfo() {
    SeqSample *seq = createSample();
    std::string sequencename = seq->get_typeinfo().get_typename();
    delete seq;
    CPPUNIT_ASSERT_EQUAL(std::string("sample_sequence"), sequencename);
  }


  void test_equality0(){
    SeqSample *seq = createSample();
    SeqSample *seq1 = createSample();

    bool isEqual = seq->is_equal_to(seq1);
    delete seq;
    delete seq1;

    CPPUNIT_ASSERT_MESSAGE("Equality test failed.", isEqual);
  }

  void test_equality1(){
    SeqSample *seq = createSample();
    SeqSample *seq1 = createSample();

    seq->simpletype_.value_ = "Test";

    bool isEqual = seq->is_equal_to(seq1);
    delete seq;
    delete seq1;

    CPPUNIT_ASSERT_MESSAGE("Equality test failed.", !isEqual);
  }


  void test_copy() {
    SeqSample *seq = createSample();
    SeqSample *seq1 = SeqSample::create();
    seq->copy_to(seq1);
    bool isEqual = seq->is_equal_to(seq1);

    delete seq;
    delete seq1;

    CPPUNIT_ASSERT_MESSAGE("Sequence::CopyTo failed.", isEqual);
  }

  void test_replicate(){
    SeqSample *seq = createSample();
    SeqSample *seq1 = seq->replicate();
    bool isEqual = seq->is_equal_to(seq1);
    delete seq;
    delete seq1;
    
    CPPUNIT_ASSERT_MESSAGE("Replication of Sequence instance failed.", isEqual);
  }

  void test_serialize() {
    std::ostringstream ostm;
    akaxiso::xmlserializer ser;
    
    doc_ = MyDoc::create();
    setValues(doc_->get_root());
    ser.serialize(doc_, ostm);

//      std::cout << ostm.rdbuf()->str() << std::endl;
  }

  void test_parse() {
    std::ostringstream ostm;
    akaxiso::xmlserializer ser;
    
    doc_ = MyDoc::create();
    setValues(doc_->get_root());
    ser.serialize(doc_, ostm);
    
    akaxiso::yggxml_parser parser;
    doc1_ = static_cast<MyDoc*>(parser.parse(ostm.rdbuf()->str()));

    bool is_equal = doc_->get_root()->is_equal_to(doc1_->get_root());
    if (!is_equal) {
      ser.serialize(doc_, ostm);
      std::cout << ostm.str();
    }

    CPPUNIT_ASSERT_MESSAGE("Parsed document is not the same as original.", is_equal);
  }

//    void test_wrongSequence0() {
    
//      adom::string doc = 
//        "<?xml version=\"1.0\"?>"
//        "<MyDoc>"
//        "  <double>0.2</double>"
//        "  <long>2</long>" // Should be <float>
//        "  <float>3.0</float>"
//        "  <short>2</short>"
//        "  <string>Test</string>"
//        "</MyDoc>";


//      adom::XMLParser parser;
//      doc1_ = static_cast<MyDoc*>(parser.parse(doc.c_str()));
//    }


//    void test_wrongSequence1() {
    
//      adom::string doc = 
//        "<?xml version=\"1.0\"?>"
//        "<MyDoc>"
//        "  <double>0.2</double>"
//        "  <float>3.0</float>"
//        "  <long>2</long>"
//        "  <short>2</short>"
//        // Lack of element.
//        //      "  <string>Test</string>"
//        "</MyDoc>";
//      adom::XMLParser parser;
//      doc1_ = static_cast<MyDoc*>(parser.parse(doc.c_str()));
//    }


//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(SimpleTypeTest);
