/* -*- c++ -*- */
#include "akaxiso.h"
#include "formatter.h"
#include "classes/namespaces.h"
#include "classes/type_registry.h"
#include "classes/closure.h"
#include "classes/any.h"
#include "classes/namespace_statics.h"
#include "classes/any_op.h"
#include "classes/preconditions.h"

#ifdef USE_XERCESC
#include <xercesc/util/PlatformUtils.hpp> /* {Xerces-C++} */
#endif

using namespace aka2;

namespace {
  preconditions pcd_;
  document_factory  doc_factory_;
  type_registry     type_registry_;
  int init_count_ = 0;
}

void aka2::use_xerces_transcoder(bool use) {
  formatter::use_xerces_transcoder_ = use;
}

const preconditions &aka2::system_preconditions() {
  return pcd_;
}

document_factory& aka2::system_document_factory() {
  return doc_factory_;
} 

type_registry &aka2::system_type_registry() {
  return type_registry_;
}


void aka2::initialize() {
  if (++init_count_ != 1)
    return;

  babel::init_babel();

#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Initialize();
  use_xerces_transcoder(true);
#endif

  namespaces_   .initialize();
  doc_factory_  .clear();
  type_registry_.initialize();
  prefix_map    ::initialize();
  pfs_.clear();
  enclose_op    ::initialize();
  disclose_op   ::initialize();
  any_op        ::initialize();
  any_array_op  ::initialize();
}

void aka2::uninitialize() {
  if (init_count_ == 0 || --init_count_ != 0)
    return;

  any_op       ::uninitialize();
  any_array_op::uninitialize();
  namespaces_   .clear();
  pfs_.clear();
  doc_factory_  .clear();
  type_registry_.uninitialize();
  
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Terminate();
#endif
}
