/* -*- c++ -*- */
#ifndef AKAXISO_BUILTIN_H__
#define AKAXISO_BUILTIN_H__

#include <string>
#include <list>
#include <vector>

#include <akaxiso/configuration.h>
#include <akaxiso/platform.h>
#include <akaxiso/classes/item.h>
#include <akaxiso/classes/any.h>
#include <akaxiso/classes/deep_ptr.h>

/** Here's the akaxiso's builtin types. 
    ------------------------------------------------------------
    Numeric types          min           max   XML-Schema type
    char                  -128           128   xs:byte
    unsigned char            0           255   xs:unsignedByte
    short               -32768         32767   xs:short   
    unsigned short           0         65535   xs:unsignedShort 
    long           -2147483648    2147483647   xs:int, xs:integer
    unsigned long            0        2^32-1   xs:unsignedInt,
    LONGLONG             -2^63        2^63-1   xs:long, 
    ULONGLONG                0        2^64-1   xs:unsignedLong,
    int                  compiler-dependent.   (Not mapped.)
    ------------------------------------------------------------
    boolean type
    bool     true/false (0/1)     xs:boolean
    ------------------------------------------------------------
    floating-point number
    float
    double
    ------------------------------------------------------------
    string type.
    std::string
    ------------------------------------------------------------
    aka::nill  empty type.
    ------------------------------------------------------------
*/


namespace aka2 {
  
  struct nill {};
  typedef std::vector<nill> nill_array;
  
  /** arrays for c++ builtins. */
  typedef std::vector<char> char_array;
  typedef std::vector<unsigned char> uchar_array;
  typedef std::vector<short> short_array;
  typedef std::vector<unsigned short> ushort_array;
  typedef std::vector<long> long_array;
  typedef std::vector<unsigned long> ulong_array;
  typedef std::vector<LONGLONG> longlong_array;
  typedef std::vector<ULONGLONG> ulonglong_array;
  typedef std::vector<int> int_array;
  typedef std::vector<bool> bool_array;
  typedef std::vector<float> float_array;
  typedef std::vector<double> double_array;
  typedef std::vector<std::string> string_array;
}


#endif
